/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.CommandResultFileObject;
import com.zutubi.pulse.vfs.pulse.RecipeResultProvider;
import com.zutubi.pulse.vfs.pulse.TextMessageFileObject;
import java.util.LinkedList;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class ArtifactStageFileObject
extends AbstractPulseFileObject
implements RecipeResultProvider {
    private final String STAGE_FORMAT = "stage :: %s :: %s@%s";
    private final long recipeId;
    private static final String IN_PROGRESS = "this stage is currently in progress";

    public ArtifactStageFileObject(FileName name, long recipeId, AbstractFileSystem fs) {
        super(name, fs);
        this.recipeId = recipeId;
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        String childName = fileName.getBaseName();
        if (childName.equals(IN_PROGRESS)) {
            return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(TextMessageFileObject.class, new Class[]{FileName.class, String.class, AbstractFileSystem.class}, new Object[]{fileName, "progress", this.pfs}));
        }
        long commandResultId = Long.parseLong(fileName.getBaseName());
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(CommandResultFileObject.class, new Class[]{FileName.class, Long.TYPE, AbstractFileSystem.class}, new Object[]{fileName, commandResultId, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected void doAttach() throws Exception {
        this.childrenChanged(null, null);
    }

    protected String[] doListChildren() throws Exception {
        LinkedList<String> children = new LinkedList<String>();
        RecipeResult recipeResult = this.buildManager.getRecipeResult(this.recipeId);
        if (!recipeResult.completed()) {
            return new String[]{IN_PROGRESS};
        }
        for (CommandResult commandResult : recipeResult.getCommandResults()) {
            children.add(Long.toString(commandResult.getId()));
        }
        return children.toArray(new String[children.size()]);
    }

    public String getDisplayName() {
        RecipeResultNode node = this.buildManager.getResultNodeByResultId(this.recipeId);
        return String.format("stage :: %s :: %s@%s", node.getStage(), node.getResult().getRecipeNameSafe(), node.getHostSafe());
    }

    public RecipeResult getRecipeResult() {
        return this.buildManager.getRecipeResult(this.getRecipeResultId());
    }

    public long getRecipeResultId() {
        return this.recipeId;
    }
}

