/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.ArtifactProvider;
import com.zutubi.pulse.vfs.pulse.FileArtifactFileObject;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactFileObject
extends AbstractPulseFileObject
implements ArtifactProvider,
AddressableFileObject {
    private final long artifactId;
    private boolean isHtmlArtifact;
    private boolean isLinkArtifact;
    private File artifactBase;
    private StoredArtifact artifact;
    private CommandResult commandResult;

    public ArtifactFileObject(FileName name, long artifactId, AbstractFileSystem fs) {
        super(name, fs);
        this.artifactId = artifactId;
    }

    @Override
    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        File base = this.getArtifactBase();
        File newBase = new File(base, fileName.getBaseName());
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(FileArtifactFileObject.class, new Class[]{FileName.class, File.class, AbstractFileSystem.class}, new Object[]{fileName, newBase, this.pfs}));
    }

    @Override
    public File toFile() {
        return this.getArtifactBase();
    }

    protected void doAttach() throws Exception {
        StoredArtifact artifact = this.getArtifact();
        this.isHtmlArtifact = artifact.hasIndexFile() && !this.getArtifact().isSingleFile();
        this.isLinkArtifact = artifact.isLink();
    }

    private File getArtifactBase() {
        if (this.artifactBase == null) {
            CommandResult result = this.getCommandResult();
            StoredArtifact artifact = this.getArtifact();
            File outputDir = result.getAbsoluteOutputDir(this.pfs.getConfigurationManager().getDataDirectory());
            this.artifactBase = new File(outputDir, artifact.getName());
        }
        return this.artifactBase;
    }

    protected FileType doGetType() throws Exception {
        if (this.isHtmlArtifact || this.isLinkArtifact || !this.getArtifactBase().isDirectory()) {
            return FileType.FILE;
        }
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        if (this.isHtmlArtifact || this.isLinkArtifact) {
            return new String[0];
        }
        File base = this.getArtifactBase();
        if (base.isDirectory()) {
            return base.list();
        }
        return new String[0];
    }

    @Override
    public String getFileType() throws FileSystemException {
        if (this.isLinkArtifact) {
            return "link";
        }
        if (!this.getArtifactBase().isDirectory()) {
            return "broken";
        }
        if (this.isHtmlArtifact) {
            return "html";
        }
        return super.getFileType();
    }

    @Override
    public String getDisplayName() {
        return this.getArtifact().getName();
    }

    @Override
    public List<String> getActions() {
        LinkedList<String> actions = new LinkedList<String>();
        if (this.isLinkArtifact) {
            actions.add("link");
        } else if (this.getArtifactBase().isDirectory()) {
            if (this.isHtmlArtifact) {
                actions.add("download");
            }
            actions.add("archive");
        }
        return actions;
    }

    @Override
    public boolean isLocal() {
        return !this.isLinkArtifact;
    }

    @Override
    public String getUrlPath() {
        if (this.isHtmlArtifact) {
            return "/file/artifacts/" + this.artifactId + "/" + this.getArtifact().findIndexFile();
        }
        if (this.isLinkArtifact) {
            return this.getArtifact().getUrl();
        }
        return null;
    }

    @Override
    public StoredArtifact getArtifact() {
        if (this.artifact == null) {
            this.artifact = this.buildManager.getArtifact(this.artifactId);
        }
        return this.artifact;
    }

    @Override
    public long getArtifactId() {
        return this.artifactId;
    }

    public CommandResult getCommandResult() {
        if (this.commandResult == null) {
            this.commandResult = this.buildManager.getCommandResultByArtifact(this.artifactId);
        }
        return this.commandResult;
    }

    public long getCommandResultId() {
        return this.getCommandResult().getId();
    }
}

