/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.vfs.pulse.PulseFileSystem;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPulseFileObject
extends AbstractFileObject {
    protected ObjectFactory objectFactory;
    protected BuildManager buildManager;
    protected ProjectManager projectManager;
    protected PulseFileSystem pfs;

    public AbstractPulseFileObject(FileName name, AbstractFileSystem fs) {
        super(name, fs);
        this.pfs = (PulseFileSystem)fs;
    }

    public abstract AbstractPulseFileObject createFile(FileName var1) throws Exception;

    public String getDisplayName() {
        return this.getName().getBaseName();
    }

    public List<String> getActions() {
        return new LinkedList<String>();
    }

    public File toFile() {
        return null;
    }

    public void init() {
    }

    public AbstractPulseFileObject getAncestor(Class type) throws FileSystemException {
        if (type.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this;
        }
        AbstractPulseFileObject parent = (AbstractPulseFileObject)this.getParent();
        if (parent != null) {
            return parent.getAncestor(type);
        }
        return null;
    }

    protected long doGetContentSize() throws Exception {
        return 0L;
    }

    protected InputStream doGetInputStream() throws Exception {
        return null;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public String getFileType() throws FileSystemException {
        FileType type = this.getType();
        if (type == FileType.FOLDER) {
            return "folder";
        }
        if (type == FileType.FILE) {
            return "file";
        }
        return "unknown";
    }
}

