/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.local;

import com.zutubi.pulse.vfs.local.LocalFile;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.util.Os;
import org.apache.commons.vfs.util.OsFamily;

public class LocalFileSystem
extends org.apache.commons.vfs.provider.local.LocalFileSystem {
    private List<FileName> rootNames;
    private final String rootFile;

    public LocalFileSystem(FileName rootName, String rootFile, FileSystemOptions opts) {
        super(rootName, rootFile, opts);
        this.rootFile = rootFile;
    }

    public void init() throws FileSystemException {
        super.init();
        this.loadFileSystemRoots();
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        return new LocalFile(this, this.rootFile, name);
    }

    private void loadFileSystemRoots() throws FileSystemException {
        this.rootNames = new LinkedList<FileName>();
        for (File root : File.listRoots()) {
            this.rootNames.add(this.getFileSystemManager().resolveName(this.getRootName(), root.getAbsolutePath()));
        }
    }

    protected String[] getRoots() {
        LinkedList<String> roots = new LinkedList<String>();
        for (FileName rootName : this.rootNames) {
            roots.add(rootName.getPath());
        }
        return roots.toArray(new String[roots.size()]);
    }

    protected boolean isRoot(String name) {
        try {
            FileName rootName = this.getFileSystemManager().resolveName(this.getRootName(), name);
            if (this.rootNames.contains(rootName)) {
                return true;
            }
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected boolean isWindows() {
        return Os.isFamily((OsFamily)Os.OS_FAMILY_WINDOWS);
    }
}

