/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.local;

import com.zutubi.pulse.vfs.local.LocalFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.RandomAccessMode;

public class LocalFile
extends AbstractFileObject
implements FileObject {
    private File file;
    private LocalFileSystem fs;

    protected LocalFile(LocalFileSystem fileSystem, String rootFile, FileName name) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.fs = fileSystem;
    }

    protected File getLocalFile() {
        return this.file;
    }

    protected void doAttach() throws Exception {
        if (this.file == null) {
            this.file = this.getFileInfo();
        }
    }

    protected FileType doGetType() throws Exception {
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.IMAGINARY;
    }

    protected String[] doListChildren() throws Exception {
        String path = this.getName().getPath();
        if (this.fs.isWindows() && path.equals("/")) {
            return this.fs.getRoots();
        }
        return UriParser.encode((String[])this.file.list());
    }

    protected File getFileInfo() {
        String path = this.getName().getPath();
        if (this.isRoot()) {
            return new File(path + "/");
        }
        return new File(path);
    }

    protected boolean isRoot() {
        String path = this.getName().getPath();
        return this.fs.isWindows() && this.fs.isRoot(path);
    }

    protected void doDelete() throws Exception {
        if (!this.file.delete()) {
            throw new FileSystemException("vfs.provider.local/delete-file.error", (Object)this.file);
        }
    }

    protected void doRename(FileObject newfile) throws Exception {
        LocalFile newLocalFile = (LocalFile)FileObjectUtils.getAbstractFileObject((FileObject)newfile);
        if (!this.file.renameTo(newLocalFile.getLocalFile())) {
            throw new FileSystemException("vfs.provider.local/rename-file.error", (Object[])new String[]{this.file.toString(), newfile.toString()});
        }
    }

    protected void doCreateFolder() throws Exception {
        if (!this.file.mkdirs()) {
            throw new FileSystemException("vfs.provider.local/create-folder.error", (Object)this.file);
        }
    }

    protected boolean doIsWriteable() throws FileSystemException {
        return this.file.canWrite();
    }

    protected boolean doIsHidden() {
        if (this.isRoot()) {
            return false;
        }
        return this.file.isHidden();
    }

    protected boolean doIsReadable() throws FileSystemException {
        return this.file.canRead();
    }

    protected long doGetLastModifiedTime() throws FileSystemException {
        return this.file.lastModified();
    }

    protected void doSetLastModifiedTime(long modtime) throws FileSystemException {
        this.file.setLastModified(modtime);
    }

    protected InputStream doGetInputStream() throws Exception {
        return new FileInputStream(this.file);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new FileOutputStream(this.file.getPath(), bAppend);
    }

    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return null;
    }

    protected boolean doIsSameFile(FileObject destFile) throws FileSystemException {
        if (!FileObjectUtils.isInstanceOf((FileObject)destFile, LocalFile.class)) {
            return false;
        }
        LocalFile destLocalFile = (LocalFile)FileObjectUtils.getAbstractFileObject((FileObject)destFile);
        if (!this.exists() || !destLocalFile.exists()) {
            return false;
        }
        try {
            return this.file.getCanonicalPath().equals(destLocalFile.file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
    }
}

