/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.agent;

import com.zutubi.pulse.vfs.agent.AgentFileName;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;

public class AgentFileNameParser
extends AbstractFileNameParser {
    private static final FileNameParser INSTANCE = new AgentFileNameParser();

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public AgentFileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        name.append(filename);
        String scheme = UriParser.extractScheme((String)filename, (StringBuffer)name);
        if (name.length() < 2 || name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", (Object)filename);
        }
        name.delete(0, 2);
        String address = this.extractRemoteAddress(name);
        UriParser.canonicalizePath((StringBuffer)name, (int)0, (int)name.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuffer)name);
        FileType fileType = UriParser.normalisePath((StringBuffer)name);
        String path = name.toString();
        return new AgentFileName(scheme, address, path, fileType);
    }

    private String extractRemoteAddress(StringBuffer name) {
        int maxlen = name.length();
        for (int pos = 0; pos < maxlen; ++pos) {
            char ch = name.charAt(pos);
            if (ch != '/') continue;
            String address = name.substring(0, pos);
            name.delete(0, pos);
            return address;
        }
        String address = name.toString();
        name.delete(0, name.length());
        return address;
    }
}

