/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.velocity;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.form.MessagesTextProvider;
import com.zutubi.pulse.form.descriptor.DescriptorFactory;
import com.zutubi.pulse.form.ui.FormSupport;
import com.zutubi.pulse.velocity.AbstractDirective;
import freemarker.template.Configuration;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.parser.node.Node;

public class FormDirective
extends AbstractDirective {
    private Configuration configuration;
    private DescriptorFactory descriptorFactory;
    private String object;
    private String theme;

    public FormDirective() {
        ComponentContext.autowire((Object)((Object)this));
    }

    public String getName() {
        return "form";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Map params = this.createPropertyMap(context, node);
        this.wireParams(params);
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        Object instance = stack.findValue(this.object);
        writer.write(this.internalRender(instance));
        return true;
    }

    public void setObject(String name) {
        this.object = name;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    private String internalRender(Object subject) {
        FormSupport support = this.createFormSupport(subject);
        try {
            return support.renderForm(subject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private FormSupport createFormSupport(Object subject) {
        FormSupport support = new FormSupport();
        support.setConfiguration(this.configuration);
        support.setDescriptorFactory(this.descriptorFactory);
        support.setTextProvider(new MessagesTextProvider(subject));
        support.setTheme(this.theme);
        return support;
    }

    public void setFreemarkerConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setDescriptorFactory(DescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }
}

