/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.velocity;

import com.opensymphony.webwork.views.velocity.VelocityManager;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.zutubi.pulse.Version;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.security.AcegiUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.context.Context;

public class CustomVelocityManager
extends VelocityManager {
    private MasterConfigurationManager configManager;
    private UserManager userManager;

    public Context createContext(OgnlValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        Context context = super.createContext(stack, req, res);
        MasterConfiguration config = this.configManager.getAppConfig();
        context.put("helpUrl", (Object)config.getHelpUrl());
        context.put("rssEnabled", (Object)config.getRssEnabled());
        context.put("config", (Object)config);
        String login = AcegiUtils.getLoggedInUser();
        if (login != null && this.getUserManager() != null) {
            User user = this.getUserManager().getUser(login);
            context.put("principle", (Object)user);
            context.put("canLogout", (Object)AcegiUtils.canLogout());
        }
        Version v = Version.getVersion();
        context.put("version_number", (Object)v.getVersionNumber());
        context.put("build_date", (Object)v.getBuildDate());
        context.put("build_number", (Object)v.getBuildNumber());
        context.put("license", (Object)LicenseHolder.getLicense());
        return context;
    }

    public void setConfigurationManager(MasterConfigurationManager configManager) {
        this.configManager = configManager;
    }

    public UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)ComponentContext.getBean((String)"userManager");
        }
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

