/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.velocity;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.velocity.AbstractDirective;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.acegisecurity.taglibs.authz.AuthorizeTag;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.parser.node.Node;

public class AuthorizeDirective
extends AbstractDirective {
    private static final Logger LOG = Logger.getLogger(AuthorizeDirective.class);
    private AuthorizeTag delegateTag = new AuthorizeTag();

    public AuthorizeDirective() {
        ComponentContext.autowire((Object)((Object)this));
    }

    public String getName() {
        return "authorize";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        try {
            Map params = this.createPropertyMap(context, node);
            this.wireParams(params);
            if (this.delegateTag.doStartTag() == 1) {
                String body = this.extractBodyContext(node, context);
                writer.write(body);
            }
            return true;
        }
        catch (JspException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void setIfAllGranted(String ifAllGranted) {
        try {
            this.delegateTag.setIfAllGranted(ifAllGranted);
        }
        catch (JspException e) {
            LOG.severe((Throwable)e);
        }
    }

    public void setIfAnyGranted(String ifAnyGranted) {
        try {
            this.delegateTag.setIfAnyGranted(ifAnyGranted);
        }
        catch (JspException e) {
            LOG.severe((Throwable)e);
        }
    }

    public void setIfNotGranted(String ifNotGranted) {
        try {
            this.delegateTag.setIfNotGranted(ifNotGranted);
        }
        catch (JspException e) {
            LOG.severe((Throwable)e);
        }
    }
}

