/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.velocity;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.velocity.AbstractDirective;
import com.zutubi.pulse.velocity.AclTag;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.parser.node.Node;

public class AclDirective
extends AbstractDirective {
    private static final Logger LOG = Logger.getLogger(AclDirective.class);
    private AclTag delegateTag = new AclTag();

    public AclDirective() {
        ComponentContext.autowire((Object)((Object)this));
    }

    public String getName() {
        return "acl";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        try {
            Map params = this.createPropertyMap(context, node);
            if (params.containsKey("domainObject")) {
                String value = (String)params.get("domainObject");
                if (context.containsKey((Object)value)) {
                    params.put("domainObject", context.get(value));
                } else {
                    OgnlValueStack stack = ActionContext.getContext().getValueStack();
                    Object o = stack.findValue(value);
                    if (o != null) {
                        params.put("domainObject", o);
                    }
                }
            }
            this.wireParams(params);
            if (this.delegateTag.doStartTag() == 1) {
                String body = this.extractBodyContext(node, context);
                writer.write(body);
            }
            return true;
        }
        catch (JspException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void setDomainObject(Object domainObject) {
        this.delegateTag.setDomainObject(domainObject);
    }

    public void setHasPermission(String hasPermission) {
        this.delegateTag.setHasPermission(hasPermission);
    }
}

