/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.util.pagination;

import com.zutubi.pulse.util.pagination.Pager;
import java.util.ArrayList;
import java.util.List;

public class DefaultPager
implements Pager {
    private final List data;
    private int pageSize = 10;

    public DefaultPager(List data) {
        this.data = data;
    }

    public DefaultPager(Object[] data) {
        this.data = new ArrayList(data.length);
        for (Object aData : data) {
            this.data.add(aData);
        }
    }

    public List getPage(int index) {
        if (index < 0 || index != 0 && index >= this.getPageCount()) {
            throw new IndexOutOfBoundsException("index " + index);
        }
        int startIndex = index * this.pageSize;
        int endIndex = (index + 1) * this.pageSize;
        if (endIndex > this.data.size()) {
            endIndex = this.data.size();
        }
        return this.data.subList(startIndex, endIndex);
    }

    public int getPageCount() {
        return this.data.size() / this.pageSize + (this.data.size() % this.pageSize == 0 ? 0 : 1);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.pageSize = size;
    }

    public int getDataSize() {
        return this.data.size();
    }
}

