/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.JDBCUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class TriggerBuildSpecificationUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Trigger build specification";
    }

    public String getDescription() {
        return "This upgrade task changes the way triggers refer to build specifications";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException, IOException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("SELECT id, project, data FROM trigger WHERE task_class = 'com.zutubi.pulse.scheduling.tasks.BuildProjectTask'");
            rs = ps.executeQuery();
            while (rs.next()) {
                if (!this.updateTrigger(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"), JDBCUtils.getLong((ResultSet)rs, (String)"project"), rs.getBytes("data"))) continue;
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)ps);
            throw throwable;
        }
        {
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((PreparedStatement)ps);
            return;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)ps);
    }

    private boolean updateTrigger(Connection con, Long id, Long projectId, byte[] data) throws IOException, SQLException {
        boolean bl;
        Serializable serializable;
        Map dataMap;
        ObjectOutputStream oos;
        ObjectInputStream ois;
        block5: {
            ois = null;
            oos = null;
            ois = new ObjectInputStream(new ByteArrayInputStream(data));
            dataMap = (Map)ois.readObject();
            serializable = (Serializable)dataMap.get("spec");
            if (!(serializable instanceof Long)) break block5;
            boolean bl2 = true;
            IOUtils.close((Closeable)ois);
            IOUtils.close(oos);
            return bl2;
        }
        try {
            String specName = (String)((Object)serializable);
            Long specId = this.getSpecId(con, projectId, specName);
            dataMap.put("spec", specId);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(byteStream);
            oos.writeObject(dataMap);
            data = byteStream.toByteArray();
            this.updateDataMap(con, id, data);
            bl = false;
        }
        catch (ClassNotFoundException e) {
            try {
                throw new IOException(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.close(ois);
                IOUtils.close(oos);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)ois);
        IOUtils.close((Closeable)oos);
        return bl;
    }

    private Long getSpecId(Connection con, Long projectId, String specName) throws SQLException, IOException {
        block3: {
            Long l;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = con.prepareStatement("SELECT id FROM build_specification WHERE project_id = ? and name = ?");
                ps.setLong(1, projectId);
                ps.setString(2, specName);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                l = rs.getLong("id");
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close((PreparedStatement)ps);
                throw throwable;
            }
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((PreparedStatement)ps);
            return l;
        }
        throw new IOException("No build specification '" + specName + "' found for project " + projectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataMap(Connection con, Long id, byte[] data) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("UPDATE trigger SET data = ? WHERE id = ?");
            stmt.setBytes(1, data);
            stmt.setLong(2, (long)id);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    public boolean haltOnFailure() {
        return false;
    }
}

