/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.TestCaseResult;
import com.zutubi.pulse.core.model.TestResultSummary;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.upgrade.ConfigurationAware;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.upgrade.tasks.HibernateUtils;
import com.zutubi.pulse.upgrade.tasks.OriginalTestSuitePersister;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TestStorageUpgradeTask
extends DatabaseUpgradeTask
implements ConfigurationAware {
    private static final Logger LOG = Logger.getLogger(TestStorageUpgradeTask.class);
    private MasterConfigurationManager configurationManager;
    private long nextId;
    private OriginalTestSuitePersister persister = new OriginalTestSuitePersister();

    public String getName() {
        return "Test storage";
    }

    public String getDescription() {
        return "Moves test results from the database to disk and improves layout and performance for large test suites";
    }

    public boolean haltOnFailure() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        this.nextId = HibernateUtils.getNextId(con);
        this.processRecipes(con);
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("DROP TABLE test_result");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecipes(Connection con) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id, outputDir FROM RECIPE_RESULT");
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.processRecipe(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"), JDBCUtils.getString((ResultSet)rs, (String)"outputDir"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecipe(Connection con, Long id, String outputDir) {
        TestSuiteResult testResults = new TestSuiteResult();
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id FROM COMMAND_RESULT where RECIPE_RESULT_ID = ?");
            JDBCUtils.setLong((PreparedStatement)stmt, (int)1, (Long)id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.processCommand(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"), testResults);
            }
            this.insertTestSummary(con, id, testResults);
            this.saveTestResults(outputDir, testResults);
        }
        catch (Exception e) {
            try {
                LOG.warning("Unable to convert test results for recipe " + id + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close((PreparedStatement)stmt);
                throw throwable;
            }
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((PreparedStatement)stmt);
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    private void saveTestResults(String outputDir, TestSuiteResult testResults) throws IOException {
        File absoluteOutput = new File(this.configurationManager.getDataDirectory(), outputDir);
        File testDir = new File(absoluteOutput, "tests");
        if (!testDir.isDirectory() && !testDir.mkdirs()) {
            throw new IOException("Unable to create test directory '" + testDir.getAbsolutePath() + "'");
        }
        this.persister.write(testResults, testDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTestSummary(Connection con, Long recipeId, TestSuiteResult testResults) throws SQLException {
        TestResultSummary summary = testResults.getSummary();
        CallableStatement stmt = null;
        long id = this.nextId++;
        try {
            stmt = con.prepareCall("INSERT INTO test_result_summary VALUES (?, ?, ?, ?)");
            JDBCUtils.setLong((PreparedStatement)stmt, (int)1, (Long)id);
            JDBCUtils.setInt((PreparedStatement)stmt, (int)2, (Integer)summary.getErrors());
            JDBCUtils.setInt((PreparedStatement)stmt, (int)3, (Integer)summary.getFailures());
            JDBCUtils.setInt((PreparedStatement)stmt, (int)4, (Integer)summary.getTotal());
            stmt.executeUpdate();
            JDBCUtils.close((PreparedStatement)stmt);
            stmt = con.prepareCall("UPDATE recipe_result SET test_summary_id = ? WHERE id = ?");
            JDBCUtils.setLong((PreparedStatement)stmt, (int)1, (Long)id);
            JDBCUtils.setLong((PreparedStatement)stmt, (int)2, (Long)recipeId);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand(Connection con, Long id, TestSuiteResult testResults) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id FROM ARTIFACT where COMMAND_RESULT_ID = ?");
            JDBCUtils.setLong((PreparedStatement)stmt, (int)1, (Long)id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.processArtifact(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"), testResults);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processArtifact(Connection con, Long id, TestSuiteResult testResults) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id FROM FILE_ARTIFACT where ARTIFACT_ID = ?");
            JDBCUtils.setLong((PreparedStatement)stmt, (int)1, (Long)id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.processFileArtifact(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"), testResults);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileArtifact(Connection con, Long id, TestSuiteResult testResults) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id, type, name, duration, statusname, message FROM TEST_RESULT where FILE_ARTIFACT_ID = ?");
            JDBCUtils.setLong((PreparedStatement)stmt, (int)1, (Long)id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.processTestResult(con, this.getResultInfo(rs), testResults);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTestResult(Connection con, TestResultInfo info, TestSuiteResult suite) throws SQLException {
        block4: {
            block3: {
                if (!info.isSuite()) break block3;
                TestSuiteResult childSuite = info.createSuite();
                CallableStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = con.prepareCall("SELECT id, type, name, duration, statusname, message FROM TEST_RESULT where SUITE_ID = ?");
                    JDBCUtils.setLong((PreparedStatement)stmt, (int)1, (Long)info.id);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        this.processTestResult(con, this.getResultInfo(rs), childSuite);
                    }
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close((PreparedStatement)stmt);
                    throw throwable;
                }
                JDBCUtils.close((ResultSet)rs);
                JDBCUtils.close((PreparedStatement)stmt);
                suite.add(childSuite);
                break block4;
            }
            suite.add(info.createCase());
        }
    }

    private TestResultInfo getResultInfo(ResultSet rs) throws SQLException {
        return new TestResultInfo(rs.getLong("id"), rs.getString("type"), rs.getString("name"), rs.getLong("duration"), rs.getString("statusname"), rs.getString("message"));
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    private class TestResultInfo {
        long id;
        String type;
        String name;
        long duration;
        TestCaseResult.Status status;
        String message;

        public TestResultInfo(long id, String type, String name, long duration, String statusName, String message) {
            this.id = id;
            this.type = type;
            this.name = name;
            this.duration = duration;
            if (statusName != null) {
                this.status = TestCaseResult.Status.valueOf((String)statusName);
            }
            this.message = message;
        }

        public boolean isSuite() {
            return this.type.equals("SUITE");
        }

        public TestSuiteResult createSuite() {
            return new TestSuiteResult(this.name, this.duration);
        }

        public TestCaseResult createCase() {
            return new TestCaseResult(this.name, this.duration, this.status, this.message);
        }
    }
}

