/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SubscriptionProjectsUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Subscription projects";
    }

    public String getDescription() {
        return "Upgrades subscriptions to allow them to refer to multiple projects";
    }

    public void execute(UpgradeContext context, Connection con) throws SQLException {
        this.addProjects(con);
        this.dropColumn(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropColumn(Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("UPDATE subscription SET project_id = null");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProjects(Connection con) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id, project_id FROM subscription");
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long id = JDBCUtils.getLong((ResultSet)rs, (String)"id");
                Long project = JDBCUtils.getLong((ResultSet)rs, (String)"project_id");
                this.addProject(con, id, project);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProject(Connection con, Long subscription, Long project) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("INSERT INTO subscription_projects VALUES (?, ?)");
            stmt.setLong(1, (long)subscription);
            stmt.setLong(2, (long)project);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    public boolean haltOnFailure() {
        return true;
    }
}

