/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SlaveEnabledStateUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Slave enabled state";
    }

    public String getDescription() {
        return "Introduces more enabled states for slave agents to allow for automatic upgrades.";
    }

    public boolean haltOnFailure() {
        return true;
    }

    public void execute(UpgradeContext context, Connection con) throws SQLException {
        this.updateStates(con);
        this.dropColumn(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStates(Connection con) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id, enabled FROM slave");
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.setEnabledState(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"), JDBCUtils.getBool((ResultSet)rs, (String)"enabled"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)stmt);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)stmt);
        JDBCUtils.close((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabledState(Connection con, Long id, Boolean enabled) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("UPDATE slave SET enable_state = ? WHERE id = ?");
            stmt.setString(1, enabled != false ? "ENABLED" : "DISABLED");
            stmt.setLong(2, (long)id);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropColumn(Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("ALTER TABLE slave DROP COLUMN enabled");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }
}

