/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.TableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaRefactor {
    private static final Logger LOG = Logger.getLogger(SchemaRefactor.class);
    private MutableConfiguration config = null;
    private Dialect dialect = null;
    private Properties connectionProperties;
    private String defaultCatalog;
    private String defaultSchema;
    private List<Exception> exceptions;

    public SchemaRefactor(MutableConfiguration config, Properties props) {
        this.config = config;
        this.dialect = Dialect.getDialect((Properties)props);
        this.connectionProperties = new Properties();
        this.connectionProperties.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        this.connectionProperties.putAll((Map<?, ?>)props);
        this.defaultCatalog = config.getProperty("hibernate.default_catalog");
        this.defaultSchema = config.getProperty("hibernate.default_schema");
    }

    public void sync() {
        SchemaUpdate schemaUpdate = new SchemaUpdate((Configuration)this.config, this.connectionProperties);
        schemaUpdate.execute(true, true);
        this.exceptions = schemaUpdate.getExceptions();
    }

    public String[] generateSyncSql() throws SQLException {
        return (String[])this.executeWithConnection(new Callback(){

            public Object execute(Connection con) throws SQLException {
                DatabaseMetadata meta = new DatabaseMetadata(con, SchemaRefactor.this.dialect);
                return SchemaRefactor.this.config.generateSchemaUpdateScript(SchemaRefactor.this.dialect, meta);
            }
        });
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public void renameTable(final String fromTableName, final String toTableName) throws SQLException {
        this.executeWithConnection(new Callback(){

            public Object execute(Connection con) throws SQLException {
                Table fromTable = SchemaRefactor.this.getTable(fromTableName);
                Table toTable = SchemaRefactor.this.copyTable(con, fromTable, toTableName);
                SchemaRefactor.this.transferForeignKeys(con, fromTable, toTable);
                SchemaRefactor.this.dropTable(con, fromTable);
                return null;
            }
        });
    }

    private void transferForeignKeys(Connection connection, Table fromTable, Table toTable) throws SQLException {
        DatabaseMetadata meta = new DatabaseMetadata(connection, this.dialect);
        Iterator i = this.config.getTableMappings();
        while (i.hasNext()) {
            Table t = (Table)i.next();
            Iterator fki = t.getForeignKeyIterator();
            while (fki.hasNext()) {
                TableMetadata tableInfo;
                ForeignKey fk = (ForeignKey)fki.next();
                Table referencedTable = fk.getReferencedTable();
                if (referencedTable == null || referencedTable != fromTable || (tableInfo = meta.getTableMetadata(t.getName(), this.defaultSchema, this.defaultCatalog)).getForeignKeyMetadata(fk.getName()) == null) continue;
                String sql = fk.sqlDropString(this.dialect, this.defaultCatalog, this.defaultSchema);
                LOG.info(sql);
                JDBCUtils.execute((Connection)connection, (String)sql);
                fk.setReferencedTable(toTable);
                sql = fk.sqlCreateString(this.dialect, null, this.defaultCatalog, this.defaultSchema);
                LOG.info(sql);
                JDBCUtils.execute((Connection)connection, (String)sql);
            }
        }
    }

    private void conditionalBuildMappings() {
        if (!this.config.getTableMappings().hasNext()) {
            this.config.buildMappings();
        }
    }

    public void refreshColumn(final String tableName, final String columnName) throws SQLException {
        this.executeWithConnection(new Callback(){

            public Object execute(Connection con) throws SQLException {
                Table table = SchemaRefactor.this.getTable(tableName);
                Column column = SchemaRefactor.this.getColumn(table, columnName);
                SchemaRefactor.this.refreshColumn(con, table, column);
                return null;
            }
        });
    }

    public void renameColumn(final String tableName, final String fromColumnName, final String toColumnName) throws SQLException {
        this.executeWithConnection(new Callback(){

            public Object execute(Connection con) throws SQLException {
                Table table = SchemaRefactor.this.getTable(tableName);
                Column column = SchemaRefactor.this.getColumn(table, fromColumnName);
                SchemaRefactor.this.renameColumn(con, table, column, toColumnName);
                return null;
            }
        });
    }

    public void dropColumn(final String tableName, final String columnName) throws SQLException {
        this.executeWithConnection(new Callback(){

            public Object execute(Connection con) throws SQLException {
                Table table = SchemaRefactor.this.getTable(tableName);
                Column column = SchemaRefactor.this.getColumn(table, columnName);
                SchemaRefactor.this.dropColumnConstraints(con, table, column);
                SchemaRefactor.this.sqlDropColumn(con, table, columnName);
                return null;
            }
        });
    }

    public void dropSchema() throws SQLException {
        this.executeWithConnection(new Callback(){

            public Object execute(Connection con) throws SQLException {
                String[] sql;
                for (String s : sql = SchemaRefactor.this.config.generateDropSchemaScript(SchemaRefactor.this.dialect)) {
                    LOG.info(s);
                }
                JDBCUtils.executeSchemaScript((Connection)con, (String[])sql);
                return null;
            }
        });
    }

    public void createSchema() throws SQLException {
        this.executeWithConnection(new Callback(){

            public Object execute(Connection con) throws SQLException {
                String[] sql;
                for (String s : sql = SchemaRefactor.this.config.generateSchemaCreationScript(SchemaRefactor.this.dialect)) {
                    LOG.info(s);
                }
                JDBCUtils.executeSchemaScript((Connection)con, (String[])sql);
                return null;
            }
        });
    }

    private Column getColumn(Table table, String columnName) {
        Iterator columns = table.getColumnIterator();
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    private void renameColumn(Connection connection, Table table, Column fromColumn, String toColumnName) throws SQLException {
        List<ForeignKey> droppedConstraints = this.dropColumnConstraints(connection, table, fromColumn);
        String fromColumnName = fromColumn.getName();
        fromColumn.setName(toColumnName);
        this.updateTableSchema(table, connection);
        this.sqlCopyColumn(connection, table.getName(), toColumnName, fromColumnName);
        this.recreatedDroppedConstraints(droppedConstraints, connection);
        this.sqlDropColumn(connection, table, fromColumnName);
    }

    private void recreatedDroppedConstraints(List<ForeignKey> droppedConstraints, Connection connection) throws SQLException {
        for (ForeignKey columnKey : droppedConstraints) {
            String sql = columnKey.sqlCreateString(this.dialect, this.config.getMapping(), this.defaultCatalog, this.defaultSchema);
            LOG.info(sql);
            JDBCUtils.execute((Connection)connection, (String)sql);
        }
    }

    private void sqlCopyColumn(Connection connection, String tableName, String toColumnName, String fromColumnName) throws SQLException {
        String sql = "update " + tableName + " set " + toColumnName + " = " + fromColumnName;
        LOG.info(sql);
        JDBCUtils.execute((Connection)connection, (String)sql);
    }

    private void updateTableSchema(Table table, Connection connection) throws SQLException {
        DatabaseMetadata meta = new DatabaseMetadata(connection, this.dialect);
        TableMetadata tableInfo = meta.getTableMetadata(table.getName(), this.defaultSchema, this.defaultCatalog);
        Iterator alterSqls = table.sqlAlterStrings(this.dialect, this.config.getMapping(), tableInfo, this.defaultCatalog, this.defaultSchema);
        while (alterSqls.hasNext()) {
            String sql = (String)alterSqls.next();
            LOG.info(sql);
            JDBCUtils.execute((Connection)connection, (String)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshColumn(Connection connection, Table table, Column column) throws SQLException {
        String columnName = column.getName();
        String tmpColumnName = "temporary_" + columnName;
        try {
            column.setName(tmpColumnName);
            this.updateTableSchema(table, connection);
        }
        finally {
            column.setName(columnName);
        }
        this.sqlCopyColumn(connection, table.getName(), tmpColumnName, columnName);
        List<ForeignKey> droppedConstraints = this.dropColumnConstraints(connection, table, column);
        this.sqlDropColumn(connection, table, columnName);
        this.updateTableSchema(table, connection);
        this.sqlCopyColumn(connection, table.getName(), columnName, tmpColumnName);
        this.recreatedDroppedConstraints(droppedConstraints, connection);
        this.sqlDropColumn(connection, table, tmpColumnName);
    }

    private List<ForeignKey> dropColumnConstraints(Connection connection, Table table, Column column) throws SQLException {
        LinkedList<ForeignKey> droppedConstraints = new LinkedList<ForeignKey>();
        Iterator fks = table.getForeignKeyIterator();
        while (fks.hasNext()) {
            ForeignKey fk = (ForeignKey)fks.next();
            if (!fk.getColumns().contains(column)) continue;
            String sql = fk.sqlDropString(this.dialect, this.defaultCatalog, this.defaultSchema);
            LOG.info(sql);
            JDBCUtils.execute((Connection)connection, (String)sql);
            droppedConstraints.add(fk);
        }
        return droppedConstraints;
    }

    private void sqlDropColumn(Connection connection, Table table, String columnName) throws SQLException {
        String sql = "alter table " + table.getName() + " drop column " + columnName;
        LOG.info(sql);
        JDBCUtils.execute((Connection)connection, (String)sql);
    }

    protected Table copyTable(Connection connection, Table fromTable, String toTableName) throws SQLException {
        this.config.buildMappings();
        Table toTable = this.clone(fromTable);
        toTable.setName(toTableName);
        String sql = toTable.sqlCreateString(this.dialect, this.config.getMapping(), this.defaultCatalog, this.defaultSchema);
        LOG.info(sql);
        JDBCUtils.execute((Connection)connection, (String)sql);
        if (JDBCUtils.executeCount((Connection)connection, (String)("select * from " + fromTable.getName())) > 0) {
            String columnSql = "";
            String sep = "";
            Iterator columns = toTable.getColumnIterator();
            while (columns.hasNext()) {
                Column column = (Column)columns.next();
                columnSql = columnSql + sep + column.getName();
                sep = ",";
            }
            sql = "insert into " + toTableName + "(" + columnSql + ") select " + columnSql + " from " + fromTable.getName();
            LOG.info(sql);
            JDBCUtils.execute((Connection)connection, (String)sql);
        }
        this.config.addTable(toTable);
        return toTable;
    }

    protected Table clone(Table table) {
        Table clone = new Table(table.getName());
        clone.setAbstract(table.isAbstract());
        clone.setCatalog(table.getCatalog());
        clone.setComment(table.getComment());
        clone.setName(table.getName());
        clone.setPrimaryKey(table.getPrimaryKey());
        clone.setQuoted(table.isQuoted());
        clone.setRowId(table.getRowId());
        clone.setSchema(table.getSchema());
        clone.setSubselect(table.getSubselect());
        Iterator columns = table.getColumnIterator();
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            clone.addColumn(column);
        }
        Iterator foreignKeys = table.getForeignKeyIterator();
        while (foreignKeys.hasNext()) {
            ForeignKey key = (ForeignKey)foreignKeys.next();
            clone.createForeignKey(key.getName(), key.getColumns(), key.getReferencedEntityName(), key.getReferencedColumns());
        }
        return clone;
    }

    protected void dropTable(Connection connection, Table table) throws SQLException {
        String sql = table.sqlDropString(this.dialect, this.defaultCatalog, this.defaultSchema);
        LOG.info(sql);
        JDBCUtils.execute((Connection)connection, (String)sql);
        this.config.removeTable(table);
    }

    protected Table getTable(String tableName) {
        Iterator tableMappings = this.config.getTableMappings();
        while (tableMappings.hasNext()) {
            Table table = (Table)tableMappings.next();
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeWithConnection(Callback c) throws SQLException {
        Object object;
        ConnectionProvider connectionProvider = null;
        Connection connection = null;
        try {
            connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)this.connectionProperties);
            connection = connectionProvider.getConnection();
            this.conditionalBuildMappings();
            object = c.execute(connection);
        }
        catch (Throwable throwable) {
            JDBCUtils.close(connection);
            if (connectionProvider != null) {
                connectionProvider.close();
            }
            throw throwable;
        }
        JDBCUtils.close((Connection)connection);
        if (connectionProvider != null) {
            connectionProvider.close();
        }
        return object;
    }

    protected static interface Callback {
        public Object execute(Connection var1) throws SQLException;
    }
}

