/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ResourceEnvironmentUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Resource environment";
    }

    public String getDescription() {
        return "Upgrade to resources to import values into the environment";
    }

    public void execute(UpgradeContext context, Connection con) throws SQLException {
        this.addPropertyColumns("resource_properties", con);
        this.addPropertyColumns("resource_version_properties", con);
        this.updateProperties("resource_properties", con);
        this.updateProperties("resource_version_properties", con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertyColumns(String table, Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("ALTER TABLE " + table + " ADD COLUMN add_to_environment BOOLEAN DEFAULT false");
            stmt.executeUpdate();
            JDBCUtils.close((PreparedStatement)stmt);
            stmt = con.prepareCall("ALTER TABLE " + table + " ADD COLUMN add_to_path BOOLEAN DEFAULT false");
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            JDBCUtils.close(stmt);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperties(String table, Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("UPDATE " + table + " SET name = 'JAVA_HOME', add_to_environment = true where name = 'java.home'");
            stmt.executeUpdate();
            JDBCUtils.close((PreparedStatement)stmt);
            stmt = con.prepareCall("UPDATE " + table + " SET name = 'ANT_HOME', add_to_environment = true where name = 'ant.home'");
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            JDBCUtils.close(stmt);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)stmt);
    }

    public boolean haltOnFailure() {
        return true;
    }
}

