/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RepairUniqueKeyUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Repair unique key";
    }

    public String getDescription() {
        return "Repairs the unique key table which may have been damaged in a beta upgrade.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT next_hi FROM hibernate_unique_key", 1004, 1007);
            rs = stmt.executeQuery();
            rs.last();
            if (rs.getRow() > 1) {
                long highest = 0L;
                do {
                    long value;
                    if ((value = rs.getLong(1)) <= highest) continue;
                    highest = value;
                } while (rs.previous());
                this.updateKey(con, highest);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKey(Connection con, long highest) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("DELETE FROM hibernate_unique_key WHERE next_hi != ?");
            JDBCUtils.setLong((PreparedStatement)stmt, (int)1, (Long)highest);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    public boolean haltOnFailure() {
        return true;
    }
}

