/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;

public class MutableConfiguration
extends Configuration {
    public void addTable(Table table) {
        String key = this.getTableKey(table);
        if (this.tables.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        this.tables.put(key, table);
    }

    private String getTableKey(Table table) {
        return table.getSubselect() == null ? Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getName()) : table.getSubselect();
    }

    public void removeTable(Table table) {
        String key = this.getTableKey(table);
        if (this.tables.remove(key) == null) {
            throw new IllegalArgumentException();
        }
    }

    public Mapping getMapping() {
        return new Mapping(){

            public Type getIdentifierType(String persistentClass) throws MappingException {
                PersistentClass pc = (PersistentClass)MutableConfiguration.this.classes.get(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                return pc.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String persistentClass) throws MappingException {
                PersistentClass pc = (PersistentClass)MutableConfiguration.this.classes.get(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String persistentClass, String propertyName) throws MappingException {
                PersistentClass pc = (PersistentClass)MutableConfiguration.this.classes.get(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                Property prop = pc.getReferencedProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + persistentClass + '.' + propertyName);
                }
                return prop.getType();
            }
        };
    }
}

