/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.upgrade.tasks.HibernateUtils;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsUpgradeTask
extends DatabaseUpgradeTask {
    private long nextId;

    @Override
    public String getName() {
        return "Groups";
    }

    @Override
    public String getDescription() {
        return "Adds user groups, assigning current privileges appropriately";
    }

    @Override
    public boolean haltOnFailure() {
        return true;
    }

    @Override
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        this.nextId = HibernateUtils.getNextId(con);
        this.addAuthority(con, 1L, "ROLE_ADMINISTRATOR");
        this.createAdminsGroup(con);
        Map<Long, UserInfo> users = this.getUsers(con);
        this.addUserAuthorities(con, users);
        Map<Long, ProjectInfo> projects = this.getProjects(con);
        this.clearAcls(con);
        List<Long> allProjectAdmins = this.determineAllProjectAdmins(users, projects);
        this.createAllProjectAdminsGroup(con, projects, allProjectAdmins);
        for (ProjectInfo project : projects.values()) {
            List<Long> members = this.determineProjectAdmins(users, project);
            if (members.size() <= 0) continue;
            this.createProjectAdminsGroup(con, project, members);
        }
        this.dropAuthorities(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAuthority(Connection con, long userId, String authority) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO user_authorities (id, user_id, authority) VALUES (?, ?, ?)");
            stmt.setLong(1, this.nextId++);
            stmt.setLong(2, userId);
            stmt.setString(3, authority);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    private void addUserAuthorities(Connection con, Map<Long, UserInfo> users) throws SQLException {
        for (Long user : users.keySet()) {
            this.addAuthority(con, user, "ROLE_USER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAdminsGroup(Connection con) throws SQLException {
        long adminGroupId = this.nextId++;
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO groups (id, name, admin_all_projects) VALUES (?, 'administrators', false)");
            stmt.setLong(1, adminGroupId);
            stmt.executeUpdate();
            JDBCUtils.close((PreparedStatement)stmt);
            stmt = con.prepareStatement("INSERT INTO group_authorities (id, group_id, authority) VALUES (?, ?, 'ROLE_ADMINISTRATOR')");
            stmt.setLong(1, this.nextId++);
            stmt.setLong(2, adminGroupId);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
        this.addServerAdmins(con, adminGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerAdmins(Connection con, long adminGroupId) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT user_id FROM AUTHORITIES WHERE authority = 'ROLE_ADMINISTRATOR'");
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long userId = rs.getLong("user_id");
                if (userId == 1L) continue;
                this.addUserToGroup(con, adminGroupId, userId);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserToGroup(Connection con, long groupId, long userId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO group_users (group_id, user_id) VALUES (?, ?)");
            stmt.setLong(1, groupId);
            stmt.setLong(2, userId);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, UserInfo> getUsers(Connection con) throws SQLException {
        HashMap<Long, UserInfo> result = new HashMap<Long, UserInfo>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT id, login FROM user");
            rs = stmt.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("id");
                UserInfo info = new UserInfo(id, rs.getString("login"));
                this.getUserProjects(con, info);
                result.put(id, info);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, ProjectInfo> getProjects(Connection con) throws SQLException {
        HashMap<Long, ProjectInfo> result = new HashMap<Long, ProjectInfo>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT id, name FROM project");
            rs = stmt.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("id");
                result.put(id, new ProjectInfo(id, rs.getString("name")));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUserProjects(Connection con, UserInfo info) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT project_id FROM project_acl_entry WHERE recipient = ?");
            stmt.setString(1, info.login);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info.projects.add(rs.getLong("project_id"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAcls(Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM project_acl_entry");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    private List<Long> determineAllProjectAdmins(Map<Long, UserInfo> users, Map<Long, ProjectInfo> projects) {
        LinkedList<Long> result = new LinkedList<Long>();
        for (UserInfo user : users.values()) {
            if (user.projects.size() != projects.size()) continue;
            user.isAllProjectAdmin = true;
            result.add(user.id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAllProjectAdminsGroup(Connection con, Map<Long, ProjectInfo> projects, List<Long> members) throws SQLException {
        long groupId = this.nextId++;
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO groups (id, name, admin_all_projects) VALUES (?, 'project administrators', true)");
            stmt.setLong(1, groupId);
            stmt.executeUpdate();
            JDBCUtils.close((PreparedStatement)stmt);
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
        for (Long projectId : projects.keySet()) {
            this.addAcl(con, projectId, groupId);
        }
        for (Long userId : members) {
            this.addUserToGroup(con, groupId, userId);
        }
    }

    private List<Long> determineProjectAdmins(Map<Long, UserInfo> users, ProjectInfo project) {
        LinkedList<Long> result = new LinkedList<Long>();
        for (UserInfo user : users.values()) {
            if (user.isAllProjectAdmin || !user.projects.contains(project.id)) continue;
            result.add(user.id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProjectAdminsGroup(Connection con, ProjectInfo project, List<Long> members) throws SQLException {
        long groupId = this.nextId++;
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO groups (id, name, admin_all_projects) VALUES (?, ?, false)");
            stmt.setLong(1, groupId);
            String groupName = project.name.equals("project") ? "project admins" : project.name + " administrators";
            stmt.setString(2, groupName);
            stmt.executeUpdate();
            JDBCUtils.close((PreparedStatement)stmt);
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
        this.addAcl(con, project.id, groupId);
        for (Long userId : members) {
            this.addUserToGroup(con, groupId, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAcl(Connection con, Long projectId, long groupId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO project_acl_entry (id, recipient, mask, project_id) VALUES (?, ?, 4, ?)");
            stmt.setLong(1, this.nextId++);
            stmt.setString(2, "GROUP_" + groupId);
            stmt.setLong(3, projectId);
            stmt.executeUpdate();
            JDBCUtils.close((PreparedStatement)stmt);
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropAuthorities(Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DROP TABLE authorities");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    private class ProjectInfo {
        public long id;
        public String name;

        public ProjectInfo(long id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private class UserInfo {
        public long id;
        public String login;
        public List<Long> projects;
        public boolean isAllProjectAdmin = false;

        public UserInfo(long id, String login) {
            this.id = id;
            this.login = login;
            this.projects = new LinkedList<Long>();
        }
    }
}

