/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FeatureCountUpgradeTask
extends DatabaseUpgradeTask {
    private static final Logger LOG = Logger.getLogger(FeatureCountUpgradeTask.class);
    private PreparedStatement selectAllBuildResults;
    private PreparedStatement selectRecipeResultByParent;
    private PreparedStatement selectCommandResultByRecipeId;
    private PreparedStatement selectFeatureLevelByCommand;
    private PreparedStatement selectFeatureLevelByBuildResult;
    private PreparedStatement selectFeatureLevelByRecipeResult;
    private PreparedStatement selectFeatureLevelByCommandResult;
    private PreparedStatement updateFeatureCountOnRecipeResult;
    private PreparedStatement updateFeatureCountOnBuildResult;
    private PreparedStatement updateFeatureCountOnCommandResult;

    public String getName() {
        return "Feature count upgrade task.";
    }

    public String getDescription() {
        return "Evaluate the warning and error feature count fields for existing build results.";
    }

    public boolean haltOnFailure() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws IOException, SQLException {
        try {
            this.prepareStatements(con);
            this.processBuilds(con);
        }
        finally {
            this.closePreparedStatements();
        }
    }

    private void prepareStatements(Connection con) throws SQLException {
        this.selectAllBuildResults = con.prepareStatement("SELECT id, recipe_result_id FROM BUILD_RESULT");
        this.selectRecipeResultByParent = con.prepareStatement("SELECT recipe_result_id FROM recipe_result_node WHERE parent_id = ?");
        this.selectCommandResultByRecipeId = con.prepareStatement("SELECT id FROM command_result where recipe_result_id = ?");
        this.selectFeatureLevelByCommand = con.prepareStatement("SELECT feature.level AS level FROM file_artifact, artifact, feature WHERE ? = artifact.command_result_id AND artifact.id = file_artifact.artifact_id AND file_artifact.id = feature.file_artifact_id");
        this.selectFeatureLevelByBuildResult = con.prepareStatement("SELECT level FROM feature WHERE build_result_id = ?");
        this.selectFeatureLevelByRecipeResult = con.prepareStatement("SELECT level FROM feature WHERE recipe_result_id = ?");
        this.selectFeatureLevelByCommandResult = con.prepareStatement("SELECT level FROM feature WHERE command_result_id = ?");
        this.updateFeatureCountOnCommandResult = con.prepareStatement("UPDATE command_result SET error_feature_count = ?, warning_feature_count = ? WHERE id = ?");
        this.updateFeatureCountOnBuildResult = con.prepareStatement("UPDATE build_result SET error_feature_count = ?, warning_feature_count = ? WHERE id = ?");
        this.updateFeatureCountOnRecipeResult = con.prepareStatement("UPDATE recipe_result SET error_feature_count = ?, warning_feature_count = ? WHERE id = ?");
    }

    private void closePreparedStatements() {
        JDBCUtils.close((PreparedStatement)this.selectAllBuildResults);
        JDBCUtils.close((PreparedStatement)this.selectRecipeResultByParent);
        JDBCUtils.close((PreparedStatement)this.selectCommandResultByRecipeId);
        JDBCUtils.close((PreparedStatement)this.selectFeatureLevelByCommand);
        JDBCUtils.close((PreparedStatement)this.selectFeatureLevelByBuildResult);
        JDBCUtils.close((PreparedStatement)this.selectFeatureLevelByRecipeResult);
        JDBCUtils.close((PreparedStatement)this.selectFeatureLevelByCommandResult);
        JDBCUtils.close((PreparedStatement)this.updateFeatureCountOnBuildResult);
        JDBCUtils.close((PreparedStatement)this.updateFeatureCountOnRecipeResult);
        JDBCUtils.close((PreparedStatement)this.updateFeatureCountOnCommandResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBuilds(Connection con) throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.selectAllBuildResults.executeQuery();
            while (rs.next()) {
                this.processBuildResult(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"), JDBCUtils.getLong((ResultSet)rs, (String)"recipe_result_id"));
            }
        }
        finally {
            JDBCUtils.close((ResultSet)rs);
        }
    }

    private void processBuildResult(Connection con, Long id, Long rootNodeId) throws SQLException {
        FeatureCount count = new FeatureCount();
        this.processFeatureCount(this.selectFeatureLevelByBuildResult, id, count);
        this.processRecipeResultHierarchy(con, rootNodeId, count);
        this.updateFeatureCount(this.updateFeatureCountOnBuildResult, id, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecipeResultHierarchy(Connection con, Long id, FeatureCount count) throws SQLException {
        ResultSet rs = null;
        try {
            this.selectRecipeResultByParent.setLong(1, id);
            rs = this.selectRecipeResultByParent.executeQuery();
            while (rs.next()) {
                this.processRecipe(con, JDBCUtils.getLong((ResultSet)rs, (String)"recipe_result_id"), count);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecipe(Connection con, Long id, FeatureCount count) throws SQLException {
        FeatureCount recipeCount = new FeatureCount();
        this.processFeatureCount(this.selectFeatureLevelByRecipeResult, id, recipeCount);
        ResultSet rs = null;
        try {
            JDBCUtils.setLong((PreparedStatement)this.selectCommandResultByRecipeId, (int)1, (Long)id);
            rs = this.selectCommandResultByRecipeId.executeQuery();
            while (rs.next()) {
                this.processCommand(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"), recipeCount);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        this.updateFeatureCount(this.updateFeatureCountOnRecipeResult, id, recipeCount);
        count.warningCount += recipeCount.warningCount;
        count.errorCount += recipeCount.errorCount;
        count.featureCount += recipeCount.featureCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand(Connection con, Long id, FeatureCount count) throws SQLException {
        FeatureCount commandCount = new FeatureCount();
        this.processFeatureCount(this.selectFeatureLevelByCommandResult, id, commandCount);
        ResultSet rs = null;
        try {
            JDBCUtils.setLong((PreparedStatement)this.selectFeatureLevelByCommand, (int)1, (Long)id);
            rs = this.selectFeatureLevelByCommand.executeQuery();
            while (rs.next()) {
                String level = JDBCUtils.getString((ResultSet)rs, (String)"level");
                if (level.equals("WARNING")) {
                    ++commandCount.warningCount;
                } else if (level.equals("ERROR")) {
                    ++commandCount.errorCount;
                }
                ++commandCount.featureCount;
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        this.updateFeatureCount(this.updateFeatureCountOnCommandResult, id, commandCount);
        count.warningCount += commandCount.warningCount;
        count.errorCount += commandCount.errorCount;
        count.featureCount += commandCount.featureCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFeatureCount(PreparedStatement stmt, Long id, FeatureCount count) throws SQLException {
        ResultSet rs = null;
        try {
            JDBCUtils.setInt((PreparedStatement)stmt, (int)1, (Integer)count.errorCount);
            JDBCUtils.setInt((PreparedStatement)stmt, (int)2, (Integer)count.warningCount);
            JDBCUtils.setLong((PreparedStatement)stmt, (int)3, (Long)id);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFeatureCount(PreparedStatement stmt, Long id, FeatureCount count) throws SQLException {
        ResultSet rs = null;
        try {
            JDBCUtils.setLong((PreparedStatement)stmt, (int)1, (Long)id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String level = JDBCUtils.getString((ResultSet)rs, (String)"level");
                ++count.featureCount;
                if (level.equals("WARNING")) {
                    ++count.warningCount;
                    continue;
                }
                if (!level.equals("ERROR")) continue;
                ++count.errorCount;
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
    }

    private class FeatureCount {
        int featureCount;
        int warningCount;
        int errorCount;

        private FeatureCount() {
        }
    }
}

