/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import org.acegisecurity.providers.encoding.Md5PasswordEncoder;

public class EncodePasswordUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Encrypt user credentials";
    }

    public String getDescription() {
        return "This upgrade tasks is for the work done in CIB-375, where user credentials are now encrypted in the database.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        LinkedList<IdPassword> results = new LinkedList<IdPassword>();
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id, password FROM user");
            rs = stmt.executeQuery();
            while (rs.next()) {
                results.add(new IdPassword(JDBCUtils.getLong((ResultSet)rs, (String)"id"), JDBCUtils.getString((ResultSet)rs, (String)"password")));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        Md5PasswordEncoder encoder = new Md5PasswordEncoder();
        for (IdPassword data : results) {
            data.password = encoder.encodePassword(data.password, null);
        }
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("UPDATE user SET password = ? WHERE id = ?");
            for (IdPassword data : results) {
                JDBCUtils.setString((PreparedStatement)ps, (int)1, (String)data.password);
                JDBCUtils.setLong((PreparedStatement)ps, (int)2, (Long)data.id);
                int rowCount = ps.executeUpdate();
                if (rowCount == 1) continue;
                this.errors.add("Failed to update password for user " + data.id + ". Row count is " + rowCount + " where 1 was expected.");
            }
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
    }

    public boolean haltOnFailure() {
        return false;
    }

    private class IdPassword {
        protected long id;
        protected String password;

        IdPassword(long id, String password) {
            this.id = id;
            this.password = password;
        }
    }
}

