/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.upgrade.tasks.HibernateUtils;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;

public class DistributedUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "1.1 data updates";
    }

    public String getDescription() {
        return "Data upgrade for 1.1 release stream";
    }

    public void execute(UpgradeContext context, Connection con) throws SQLException {
        this.addBuildReasons(con);
        this.addStageNames(con);
        this.addResultStageNames(con);
        this.removeSlaveColumns(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuildReasons(Connection con) throws SQLException {
        LinkedList<Long> buildIds = new LinkedList<Long>();
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id FROM build_result");
            rs = stmt.executeQuery();
            while (rs.next()) {
                buildIds.add(JDBCUtils.getLong((ResultSet)rs, (String)"id"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        CallableStatement reasonStmt = null;
        stmt = null;
        long nextId = HibernateUtils.getNextId(con);
        try {
            stmt = con.prepareCall("UPDATE build_result SET reason = ? where id = ?");
            reasonStmt = con.prepareCall("INSERT INTO build_reason (id, reason_type) values (?, 'UNKNOWN')");
            for (Long id : buildIds) {
                JDBCUtils.setLong((PreparedStatement)reasonStmt, (int)1, (Long)nextId);
                reasonStmt.executeUpdate();
                JDBCUtils.setLong((PreparedStatement)stmt, (int)1, (Long)nextId);
                JDBCUtils.setLong((PreparedStatement)stmt, (int)2, (Long)id);
                stmt.executeUpdate();
                ++nextId;
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)stmt);
            JDBCUtils.close(reasonStmt);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)stmt);
        JDBCUtils.close((PreparedStatement)reasonStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStageNames(Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("ALTER TABLE build_specification_node ADD COLUMN name VARCHAR(255) DEFAULT 'default'");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResultStageNames(Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("ALTER TABLE recipe_result_node ADD COLUMN stage VARCHAR(255) DEFAULT 'default'");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSlaveColumns(Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("ALTER TABLE slave DROP COLUMN last_ping_time");
            stmt.executeUpdate();
            stmt = con.prepareCall("ALTER TABLE slave DROP COLUMN status");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    public boolean haltOnFailure() {
        return true;
    }
}

