/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.DataSourceAware;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.UpgradeException;
import com.zutubi.pulse.upgrade.UpgradeTask;
import com.zutubi.pulse.upgrade.tasks.ObjectUpgrader;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseUpgradeTask
implements UpgradeTask,
DataSourceAware {
    private static final Logger LOG = Logger.getLogger(DatabaseUpgradeTask.class);
    protected DataSource dataSource;
    protected List<String> errors = new LinkedList<String>();
    protected int buildNumber;

    @Override
    public void setDataSource(DataSource source) {
        this.dataSource = source;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public int getBuildNumber() {
        return this.buildNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(UpgradeContext context) throws UpgradeException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            this.execute(context, connection);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            this.errors.add("IOException: " + e.getMessage() + ". Please see the log files for details.");
        }
        catch (SQLException e) {
            LOG.error((Throwable)e);
            this.errors.add("SQLException: " + e.getMessage() + ". Please see the log files for details.");
        }
        finally {
            JDBCUtils.close((Connection)connection);
        }
    }

    @Override
    public boolean hasFailed() {
        return this.getErrors().size() > 0;
    }

    public abstract void execute(UpgradeContext var1, Connection var2) throws IOException, SQLException;

    protected List<Long> getAllProjects(Connection con) throws SQLException {
        return this.getAllIds(con, "project");
    }

    protected List<Long> getAllUsers(Connection con) throws SQLException {
        return this.getAllIds(con, "user");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getAllIds(Connection con, String table) throws SQLException {
        LinkedList<Long> linkedList;
        CallableStatement stmt = null;
        ResultSet rs = null;
        LinkedList<Long> all = new LinkedList<Long>();
        try {
            stmt = con.prepareCall("SELECT id FROM " + table);
            rs = stmt.executeQuery();
            while (rs.next()) {
                all.add(rs.getLong("id"));
            }
            linkedList = all;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close(stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        return linkedList;
    }

    protected byte[] upgradeBlob(ResultSet rs, String columnName, ObjectUpgrader objectUpgrader) throws SQLException, IOException {
        byte[] data = rs.getBytes(columnName);
        ObjectInputStream ois = null;
        ObjectOutputStream oos = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(data));
            Object object = ois.readObject();
            objectUpgrader.upgrade(object);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(byteStream);
            oos.writeObject(object);
            data = byteStream.toByteArray();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new IOException(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.close(ois);
                IOUtils.close(oos);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)ois);
        IOUtils.close((Closeable)oos);
        return data;
    }
}

