/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardProjectGroupsUpgradeTask
extends DatabaseUpgradeTask {
    @Override
    public String getName() {
        return "Dashboard project groups";
    }

    @Override
    public String getDescription() {
        return "Upgrade to allow project groups to be chosen for display on the dashboard";
    }

    @Override
    public void execute(UpgradeContext context, Connection con) throws SQLException, IOException {
        this.updateUsers(con, this.getAllUsers(con), this.getAllProjects(con));
        this.dropTable(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUsers(Connection con, List<Long> allUsers, List<Long> allProjects) throws SQLException, IOException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        TreeMap<Long, LinkedList<Long>> userHiddenProjects = new TreeMap<Long, LinkedList<Long>>();
        try {
            stmt = con.prepareCall("SELECT user_id, project_id FROM user_hidden_projects");
            rs = stmt.executeQuery();
            while (rs.next()) {
                long user = rs.getLong("user_id");
                long project = rs.getLong("project_id");
                LinkedList<Long> projects = (LinkedList<Long>)userHiddenProjects.get(user);
                if (projects == null) {
                    projects = new LinkedList<Long>();
                    userHiddenProjects.put(user, projects);
                }
                projects.add(project);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        for (Long user : allUsers) {
            this.updateUser(con, user, (List)userHiddenProjects.get(user), allProjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUser(Connection con, Long user, List<Long> hidden, List<Long> allProjects) throws SQLException, IOException {
        boolean showAll;
        boolean bl = showAll = hidden == null || hidden.size() == 0;
        if (!showAll) {
            this.invertUserProjects(con, user, hidden, allProjects);
        }
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("INSERT INTO user_props VALUES (?, ?, ?)");
            stmt.setLong(1, (long)user);
            stmt.setString(2, Boolean.toString(showAll));
            stmt.setString(3, "show.all.projects");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invertUserProjects(Connection con, Long user, List<Long> hidden, List<Long> allProjects) throws SQLException {
        LinkedList<Long> shown = new LinkedList<Long>(allProjects);
        shown.removeAll(hidden);
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("INSERT INTO user_shown_projects VALUES (?, ?)");
            for (Long project : shown) {
                stmt.setLong(1, (long)user);
                stmt.setLong(2, (long)project);
                stmt.executeUpdate();
            }
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable(Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("DROP TABLE user_hidden_projects");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    @Override
    public boolean haltOnFailure() {
        return true;
    }
}

