/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DanglingBuildHostRequirementsUpgradeTask
extends DatabaseUpgradeTask {
    @Override
    public String getName() {
        return "Dangling build host requirements";
    }

    @Override
    public String getDescription() {
        return "Removes build host requirements entities that are no longer referenced.";
    }

    @Override
    public boolean haltOnFailure() {
        return true;
    }

    @Override
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        Set<Long> referenced = this.getAllReferenced(con);
        List<Long> unreferenced = this.getUnreferenced(con, referenced);
        this.removeUnreferenced(con, unreferenced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> getAllReferenced(Connection con) throws SQLException {
        HashSet<Long> result = new HashSet<Long>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("select BUILD_HOST_REQUIREMENTS_ID from BUILD_SPECIFICATION_NODE");
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getLong("BUILD_HOST_REQUIREMENTS_ID"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)ps);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)ps);
        JDBCUtils.close((ResultSet)rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getUnreferenced(Connection con, Set<Long> referenced) throws SQLException {
        LinkedList<Long> result = new LinkedList<Long>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("select ID from BUILD_HOST_REQUIREMENTS");
            rs = ps.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("ID");
                if (referenced.contains(id)) continue;
                result.add(id);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)ps);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)ps);
        JDBCUtils.close((ResultSet)rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnreferenced(Connection con, List<Long> unreferenced) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("delete from BUILD_HOST_REQUIREMENTS where ID = ?");
            for (Long id : unreferenced) {
                ps.setLong(1, id);
                ps.executeUpdate();
            }
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
    }
}

