/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BuildNumberUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Build number";
    }

    public String getDescription() {
        return "Upgrade to store next build number with project";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id FROM project");
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.setBuildNumber(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)stmt);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)stmt);
        JDBCUtils.close((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBuildNumber(Connection con, Long id) throws SQLException {
        long number = this.getHighestBuildNumber(con, id);
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("UPDATE project SET next_build_number = ? WHERE id = ?");
            stmt.setLong(1, number);
            stmt.setLong(2, (long)id);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getHighestBuildNumber(Connection con, Long id) throws SQLException {
        ResultSet rs;
        CallableStatement stmt;
        block3: {
            long l;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareCall("SELECT number FROM build_result WHERE project = ? ORDER BY number DESC LIMIT 1");
                stmt.setLong(1, (long)id);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                l = JDBCUtils.getLong((ResultSet)rs, (String)"number") + 1L;
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close((PreparedStatement)stmt);
                throw throwable;
            }
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((PreparedStatement)stmt);
            return l;
        }
        long l = 1L;
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        return l;
    }

    public boolean haltOnFailure() {
        return true;
    }
}

