/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.upgrade.ConfigurationAware;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AdminUserUpgradeTask
extends DatabaseUpgradeTask
implements ConfigurationAware {
    private MasterConfigurationManager configurationManager;

    public String getName() {
        return "Admin user";
    }

    public String getDescription() {
        return "Marks one user as the special admin user";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        ResultSet rs;
        CallableStatement stmt;
        block3: {
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareCall("SELECT login FROM user ORDER BY id ASC LIMIT 1");
                rs = stmt.executeQuery();
                if (rs.next()) {
                    String login = rs.getString("login");
                    this.configurationManager.getAppConfig().setAdminLogin(login);
                    break block3;
                }
                this.errors.add("Unable to find any user to mark as admin!");
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close((PreparedStatement)stmt);
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    public boolean haltOnFailure() {
        return true;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

