/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade;

import com.zutubi.pulse.Version;
import com.zutubi.pulse.bootstrap.Data;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.upgrade.ConfigurationAware;
import com.zutubi.pulse.upgrade.DefaultUpgradeContext;
import com.zutubi.pulse.upgrade.UpgradeException;
import com.zutubi.pulse.upgrade.UpgradeManager;
import com.zutubi.pulse.upgrade.UpgradeProgressMonitor;
import com.zutubi.pulse.upgrade.UpgradeTask;
import com.zutubi.pulse.upgrade.UpgradeTaskComparator;
import com.zutubi.pulse.util.logging.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUpgradeManager
implements UpgradeManager {
    private static final Logger LOG = Logger.getLogger(DefaultUpgradeManager.class);
    private List<UpgradeTask> upgradeTasks = new LinkedList<UpgradeTask>();
    private List<UpgradeTask> systemTasks = new LinkedList<UpgradeTask>();
    private DefaultUpgradeContext currentContext;
    private UpgradeProgressMonitor monitor;
    private Data upgradeTarget;
    private MasterConfigurationManager configurationManager;

    public void addTask(UpgradeTask task) {
        this.upgradeTasks.add(task);
    }

    public void setTasks(List<UpgradeTask> tasks) {
        this.upgradeTasks = tasks;
    }

    public void setTasks(UpgradeTask ... tasks) {
        this.upgradeTasks = Arrays.asList(tasks);
    }

    public void setSystemTasks(List<UpgradeTask> tasks) {
        this.systemTasks = tasks;
    }

    public boolean isUpgradeRequired(int fromBuildNumber, int toBuildNumber) {
        boolean required = toBuildNumber == -1 || fromBuildNumber < toBuildNumber;
        return required && this.determineRequiredUpgradeTasks(fromBuildNumber, toBuildNumber).size() > 0;
    }

    public List<UpgradeTask> previewUpgrade(int fromBuildNumber, int toBuildNumber) {
        return this.compileUpgradeTasks(fromBuildNumber, toBuildNumber);
    }

    protected List<UpgradeTask> determineRequiredUpgradeTasks(int fromBuildNumber, int toBuildNumber) {
        LinkedList<UpgradeTask> requiredTasks = new LinkedList<UpgradeTask>();
        if (fromBuildNumber == -1) {
            return requiredTasks;
        }
        for (UpgradeTask task : this.upgradeTasks) {
            if (fromBuildNumber >= task.getBuildNumber() || toBuildNumber != -1 && task.getBuildNumber() > toBuildNumber) continue;
            requiredTasks.add(task);
        }
        Collections.sort(requiredTasks, new UpgradeTaskComparator());
        return requiredTasks;
    }

    protected List<UpgradeTask> compileUpgradeTasks(int fromBuildNumber, int toBuildNumber) {
        List<UpgradeTask> tasks = this.determineRequiredUpgradeTasks(fromBuildNumber, toBuildNumber);
        tasks.addAll(this.systemTasks);
        Collections.sort(tasks, new UpgradeTaskComparator());
        return tasks;
    }

    @Override
    public boolean isUpgradeRequired(Data data) {
        this.checkData(data);
        Version from = data.getVersion();
        Version to = Version.getVersion();
        return this.isUpgradeRequired(from.getBuildNumberAsInt(), to.getBuildNumberAsInt());
    }

    @Override
    public void prepareUpgrade(Data data) {
        this.checkData(data);
        Version from = data.getVersion();
        Version to = Version.getVersion();
        List<UpgradeTask> tasks = this.compileUpgradeTasks(from.getBuildNumberAsInt(), to.getBuildNumberAsInt());
        for (UpgradeTask task : tasks) {
            if (!ConfigurationAware.class.isAssignableFrom(task.getClass())) continue;
            ((ConfigurationAware)((Object)task)).setConfigurationManager(this.configurationManager);
        }
        this.currentContext = new DefaultUpgradeContext(from, to);
        this.currentContext.setTasks(tasks);
        this.monitor = new UpgradeProgressMonitor();
        this.upgradeTarget = data;
    }

    @Override
    public List<UpgradeTask> previewUpgrade() {
        if (this.currentContext == null) {
            throw new IllegalArgumentException("No upgrade has been prepared.");
        }
        return this.currentContext.getTasks();
    }

    @Override
    public void executeUpgrade() {
        this.currentContext.setData(this.upgradeTarget);
        List<UpgradeTask> tasksToExecute = this.currentContext.getTasks();
        DefaultUpgradeContext context = this.currentContext;
        this.monitor.setTasks(tasksToExecute);
        this.monitor.start();
        boolean abort = false;
        for (UpgradeTask task : tasksToExecute) {
            try {
                if (!abort) {
                    this.monitor.start(task);
                    try {
                        LOG.info("Executing upgrade task: " + task.getName());
                        task.execute(context);
                    }
                    catch (UpgradeException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new UpgradeException(t);
                    }
                    if (task.hasFailed()) {
                        throw new UpgradeException(String.format("Task %s has been marked as failed.", task.getName()));
                    }
                    this.monitor.complete(task);
                    if (task.getBuildNumber() <= 0) continue;
                    this.upgradeTarget.setBuildNumber(task.getBuildNumber());
                    continue;
                }
                this.monitor.aborted(task);
            }
            catch (UpgradeException e) {
                this.monitor.failed(task);
                if (task.haltOnFailure()) {
                    abort = true;
                }
                LOG.severe((Throwable)((Object)e));
            }
        }
        if (this.monitor.isSuccessful()) {
            this.upgradeTarget.updateVersion(context.getTo());
        }
        this.monitor.setPercentageComplete(100);
        this.monitor.stop();
    }

    @Override
    public UpgradeProgressMonitor getUpgradeMonitor() {
        return this.monitor;
    }

    private void checkData(Data data) {
        if (!data.isInitialised()) {
            throw new IllegalArgumentException();
        }
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

