/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.transfer;

import com.zutubi.pulse.transfer.MappingUtils;
import com.zutubi.pulse.transfer.ProxySerializer;
import com.zutubi.pulse.transfer.TransferException;
import com.zutubi.pulse.transfer.TransferTarget;
import com.zutubi.pulse.transfer.XMLTransferSupport;
import com.zutubi.pulse.util.JDBCTypes;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTransferTarget
extends XMLTransferSupport
implements TransferTarget {
    private ProxySerializer serializer;
    private Element rootElement;
    private Element tableElement;
    private Table table;
    private String version;
    private Map<String, Integer> columnTypes;
    private OutputStream output;

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void start() throws TransferException {
        this.serializer = new ProxySerializer(this.output);
        try {
            this.rootElement = new Element("export");
            if (this.version != null) {
                this.rootElement.addAttribute(new Attribute("version", this.version));
            }
            new Document(this.rootElement);
            this.serializer.writeXMLDeclaration();
            this.serializer.writeStartTag(this.rootElement);
        }
        catch (IOException e) {
            throw new TransferException(e);
        }
    }

    @Override
    public void startTable(Table table) throws TransferException {
        try {
            this.table = table;
            this.tableElement = new Element("table");
            this.tableElement.addAttribute(new Attribute("name", table.getName()));
            this.rootElement.appendChild((Node)this.tableElement);
            this.serializer.writeStartTag(this.tableElement);
            this.writeTableDef(table);
        }
        catch (IOException e) {
            throw new TransferException(e);
        }
    }

    private void writeTableDef(Table table) throws TransferException {
        try {
            this.columnTypes = new HashMap<String, Integer>();
            Element defs = new Element("type-defs");
            this.tableElement.appendChild((Node)defs);
            Iterator columns = table.getColumnIterator();
            while (columns.hasNext()) {
                Column column = (Column)columns.next();
                Element def = new Element("type-def");
                def.addAttribute(new Attribute("name", column.getName()));
                def.addAttribute(new Attribute("type", JDBCTypes.toString((int)column.getSqlTypeCode())));
                defs.appendChild((Node)def);
                this.columnTypes.put(column.getName(), column.getSqlTypeCode());
            }
            this.serializer.write(defs);
        }
        catch (IOException e) {
            throw new TransferException(e);
        }
    }

    @Override
    public void row(Map<String, Object> row) throws TransferException {
        try {
            Element rowElement = new Element("r");
            this.tableElement.appendChild((Node)rowElement);
            this.serializer.writeStartTag(rowElement);
            for (Column column : MappingUtils.getColumns(this.table)) {
                String columnName = column.getName();
                Element columnElement = new Element("c");
                rowElement.appendChild((Node)columnElement);
                Object objValue = row.get(columnName);
                if (objValue != null) {
                    String value = this.toText(this.columnTypes.get(columnName), row.get(columnName));
                    columnElement.appendChild(value);
                } else {
                    columnElement.addAttribute(new Attribute("null", "t"));
                }
                this.serializer.write(columnElement);
            }
            this.serializer.writeEndTag(rowElement);
        }
        catch (IOException e) {
            throw new TransferException(e);
        }
    }

    @Override
    public void endTable() throws TransferException {
        try {
            this.serializer.writeEndTag(this.tableElement);
        }
        catch (IOException e) {
            throw new TransferException(e);
        }
    }

    @Override
    public void end() throws TransferException {
        try {
            this.serializer.writeEndTag(this.rootElement);
            this.serializer.flush();
        }
        catch (IOException e) {
            throw new TransferException(e);
        }
    }

    @Override
    public void close() {
    }
}

