/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.transfer;

import com.zutubi.pulse.transfer.TransferException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.ws.commons.util.Base64;

public class XMLTransferSupport {
    public String toText(int type, Object obj) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 93: {
                return obj.toString();
            }
            case 0: {
                return null;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] data = (byte[])obj;
                return Base64.encode((byte[])data, (int)0, (int)data.length, (int)0, null);
            }
        }
        throw new RuntimeException("unsupported type: " + type + " value: " + obj.toString());
    }

    public Object fromText(int type, String str) throws TransferException {
        if (str == null) {
            return null;
        }
        switch (type) {
            case -5: {
                return Long.parseLong(str);
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.parseInt(str);
            }
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                return Double.parseDouble(str);
            }
            case 2: 
            case 3: {
                return new BigDecimal(str);
            }
            case -7: 
            case 16: {
                return Boolean.parseBoolean(str);
            }
            case -1: 
            case 1: 
            case 12: {
                return str;
            }
            case -4: 
            case -3: 
            case -2: {
                try {
                    return Base64.decode((String)str);
                }
                catch (Base64.DecodingException e) {
                    throw new TransferException(e);
                }
            }
            case 93: {
                return Timestamp.valueOf(str);
            }
            case 91: {
                return Date.valueOf(str);
            }
        }
        throw new RuntimeException("unsupported type: " + type + " value: " + str);
    }
}

