/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.transfer;

import com.zutubi.pulse.transfer.HibernateUniqueKeyTable;
import com.zutubi.pulse.transfer.TransferException;
import com.zutubi.pulse.transfer.TransferSource;
import com.zutubi.pulse.transfer.TransferTarget;
import com.zutubi.pulse.transfer.XMLTransferSupport;
import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import com.zutubi.pulse.util.JDBCTypes;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nu.xom.Builder;
import nu.xom.NodeFactory;
import org.hibernate.mapping.Table;
import org.xml.sax.Attributes;

public class XMLTransferSource
extends XMLTransferSupport
implements TransferSource {
    private InputStream source;
    private MutableConfiguration configuration;
    private Map<String, String> row;
    private TransferTarget target;
    private List<String> columnNames;
    private Map<String, Integer> columnTypes;
    private Iterator<String> columnIterator;
    private String columnName;

    public void setSource(InputStream source) {
        this.source = source;
    }

    public void transferTo(TransferTarget target) throws TransferException {
        try {
            this.target = target;
            this.target.start();
            Builder builder = new Builder((NodeFactory)new Callback());
            builder.build(this.source);
            this.target.end();
        }
        catch (Exception e) {
            if (e.getCause() instanceof TransferException) {
                throw (TransferException)e.getCause();
            }
            throw new TransferException(e);
        }
    }

    protected void startTable(String uri, String localName, String qName, Attributes atts) throws TransferException {
        String tableName = atts.getValue("name");
        Table table = this.getTable(tableName);
        this.target.startTable(table);
    }

    protected void endTable(String uri, String localName, String qName) throws TransferException {
        this.target.endTable();
    }

    protected void startRow(String uri, String localName, String qName, Attributes atts) {
        this.row = new HashMap<String, String>();
        this.columnIterator = this.columnNames.iterator();
    }

    protected void endRow(String uri, String localName, String qName) throws TransferException {
        HashMap<String, Object> convertedRow = new HashMap<String, Object>();
        for (String key : this.row.keySet()) {
            Object value = this.fromText(this.columnTypes.get(key), this.row.get(key));
            convertedRow.put(key, value);
        }
        this.target.row(convertedRow);
        this.row = null;
    }

    private void startTypeDefs(CharSequence uri, String localName, String qName, Attributes atts) {
        this.columnNames = new LinkedList<String>();
        this.columnTypes = new HashMap<String, Integer>();
    }

    private void startTypeDef(CharSequence uri, String localName, String qName, Attributes atts) {
        String columnName = atts.getValue("name");
        String columnType = atts.getValue("type");
        this.columnNames.add(columnName);
        this.columnTypes.put(columnName, JDBCTypes.valueOf((String)columnType));
    }

    protected void startColumn(String uri, String localName, String qName, Attributes atts) {
        this.columnName = this.columnIterator.next();
        if (atts.getValue("null") == null) {
            this.row.put(this.columnName, "");
        }
    }

    protected void endColumn(String uri, String localName, String qName) {
        this.columnName = null;
    }

    private Table getTable(String tableName) {
        Iterator tables = this.configuration.getTableMappings();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        if (HibernateUniqueKeyTable.isTable(tableName)) {
            return HibernateUniqueKeyTable.getMapping();
        }
        return null;
    }

    public void setConfiguration(MutableConfiguration configuration) {
        this.configuration = configuration;
    }

    private class Callback
    extends NodeFactory {
        private Callback() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) {
            try {
                if (localName.equals("table")) {
                    XMLTransferSource.this.startTable(uri, localName, qName, atts);
                }
                if (localName.equals("r")) {
                    XMLTransferSource.this.startRow(uri, localName, qName, atts);
                }
                if (localName.equals("c")) {
                    XMLTransferSource.this.startColumn(uri, localName, qName, atts);
                }
                if (localName.equals("type-defs")) {
                    XMLTransferSource.this.startTypeDefs(uri, localName, qName, atts);
                }
                if (localName.equals("type-def")) {
                    XMLTransferSource.this.startTypeDef(uri, localName, qName, atts);
                }
            }
            catch (TransferException e) {
                throw new RuntimeException(e);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            try {
                if (localName.equals("c")) {
                    XMLTransferSource.this.endColumn(uri, localName, qName);
                }
                if (localName.equals("r")) {
                    XMLTransferSource.this.endRow(uri, localName, qName);
                }
                if (localName.equals("table")) {
                    XMLTransferSource.this.endTable(uri, localName, qName);
                }
            }
            catch (TransferException e) {
                throw new RuntimeException(e);
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (XMLTransferSource.this.columnName != null) {
                String str = new String(ch, start, length);
                if (XMLTransferSource.this.row.containsKey(XMLTransferSource.this.columnName)) {
                    str = (String)XMLTransferSource.this.row.get(XMLTransferSource.this.columnName) + str;
                }
                XMLTransferSource.this.row.put(XMLTransferSource.this.columnName, str);
            }
        }
    }
}

