/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.transfer;

import com.zutubi.pulse.Version;
import com.zutubi.pulse.transfer.JDBCTransferException;
import com.zutubi.pulse.transfer.JDBCTransferSource;
import com.zutubi.pulse.transfer.JDBCTransferTarget;
import com.zutubi.pulse.transfer.MappingUtils;
import com.zutubi.pulse.transfer.TransferException;
import com.zutubi.pulse.transfer.XMLTransferSource;
import com.zutubi.pulse.transfer.XMLTransferTarget;
import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.JDBCUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public class TransferAPI {
    public void dump(MutableConfiguration configuration, DataSource dataSource, File outFile) throws TransferException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outFile);
            this.dump(configuration, dataSource, outputStream);
        }
        catch (IOException e) {
            try {
                throw new TransferException(e);
            }
            catch (Throwable throwable) {
                IOUtils.close(outputStream);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(MutableConfiguration configuration, DataSource dataSource, OutputStream outputStream) throws TransferException {
        XMLTransferTarget target = null;
        try {
            if (!this.isSchemaMappingValid(configuration, dataSource)) {
                throw new JDBCTransferException("Schema export aborted due to schema / mapping mismatch");
            }
            target = new XMLTransferTarget();
            target.setOutput(outputStream);
            target.setVersion(Version.getVersion().getBuildNumber());
            JDBCTransferSource source = new JDBCTransferSource();
            source.setConfiguration(configuration);
            source.setDataSource(dataSource);
            source.transferTo(target);
        }
        finally {
            if (target != null) {
                target.close();
            }
        }
    }

    public void restore(MutableConfiguration configuration, File inFile, DataSource dataSource) throws TransferException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(inFile);
            this.restore(configuration, dataSource, inputStream);
        }
        catch (IOException e) {
            try {
                throw new TransferException(e);
            }
            catch (Throwable throwable) {
                IOUtils.close(inputStream);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(MutableConfiguration configuration, DataSource dataSource, InputStream inputStream) throws TransferException {
        JDBCTransferTarget target = null;
        try {
            target = new JDBCTransferTarget();
            target.setDataSource(dataSource);
            target.setConfiguration(configuration);
            XMLTransferSource source = new XMLTransferSource();
            source.setConfiguration(configuration);
            source.setSource(inputStream);
            source.transferTo(target);
        }
        finally {
            if (target != null) {
                target.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSchemaMappingValid(Configuration configuration, DataSource dataSource) throws TransferException {
        Connection con = null;
        try {
            try {
                con = dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new TransferException("Failed to connect to the configured dataSource.  Cause: '" + e.getMessage() + "'");
            }
            StringBuilder builder = new StringBuilder();
            builder.append("The following expected schema entities are missing from the source database:\n");
            boolean problemDetected = false;
            boolean noTablesDetected = true;
            Iterator tables = configuration.getTableMappings();
            while (tables.hasNext()) {
                Table table = (Table)tables.next();
                String tableName = table.getName();
                if (!JDBCUtils.tableExists((Connection)con, (String)tableName)) {
                    builder.append("  Table ").append(tableName).append(" is missing\n");
                    problemDetected = true;
                    continue;
                }
                noTablesDetected = false;
                LinkedList<Column> missingColumns = new LinkedList<Column>();
                List<Column> columns = MappingUtils.getColumns(table);
                for (Column column : columns) {
                    String columnName = column.getName();
                    if (JDBCUtils.columnExists((Connection)con, (String)tableName, (String)columnName)) continue;
                    missingColumns.add(column);
                    problemDetected = true;
                }
                if (missingColumns.size() <= 0) continue;
                builder.append("  Table ").append(tableName).append(" is missing column(s): ");
                String sep = "";
                for (Column column : missingColumns) {
                    builder.append(sep).append(column.getName());
                    sep = ", ";
                }
                builder.append("\n");
            }
            if (problemDetected) {
                if (noTablesDetected) {
                    System.err.println("The pulse schema could not be located. Please check that your database configuration details are correct.");
                } else {
                    System.err.println(builder.toString());
                }
            }
            boolean bl = !problemDetected;
            return bl;
        }
        finally {
            JDBCUtils.close((Connection)con);
        }
    }
}

