/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.transfer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingUtils {
    public static String sqlSelectAll(Table table) {
        StringBuilder builder = new StringBuilder();
        builder.append("select");
        String sep = " ";
        for (Column column : MappingUtils.getColumns(table)) {
            builder.append(sep).append(column.getName());
            sep = ", ";
        }
        builder.append(" from ").append(table.getName());
        return builder.toString();
    }

    public static String sqlInsert(Table table) {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ").append(table.getName());
        String sep = " (";
        for (Column column : MappingUtils.getColumns(table)) {
            builder.append(sep).append(column.getName());
            sep = ", ";
        }
        builder.append(") values (");
        sep = "";
        for (Column column : MappingUtils.getColumns(table)) {
            builder.append(sep).append("?");
            sep = ", ";
        }
        builder.append(")");
        return builder.toString();
    }

    public static List<Column> getColumns(Table table) {
        LinkedList<Column> columns = new LinkedList<Column>();
        Iterator columnIterator = table.getColumnIterator();
        while (columnIterator.hasNext()) {
            columns.add((Column)columnIterator.next());
        }
        return columns;
    }
}

