/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.transfer;

import com.zutubi.pulse.transfer.HibernateUniqueKeyTable;
import com.zutubi.pulse.transfer.JDBCTransferException;
import com.zutubi.pulse.transfer.MappingUtils;
import com.zutubi.pulse.transfer.TransferException;
import com.zutubi.pulse.transfer.TransferSource;
import com.zutubi.pulse.transfer.TransferTarget;
import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCTransferSource
implements TransferSource {
    private DataSource dataSource;
    private MutableConfiguration configuration;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setConfiguration(MutableConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferTo(TransferTarget target) throws TransferException {
        try {
            this.configuration.buildMappings();
            Mapping mapping = this.configuration.getMapping();
            target.start();
            Connection con = null;
            try {
                Table table;
                con = this.dataSource.getConnection();
                Iterator tables = this.configuration.getTableMappings();
                while (tables.hasNext()) {
                    table = (Table)tables.next();
                    List<Column> columns = MappingUtils.getColumns(table);
                    for (Column column : columns) {
                        if (column.getSqlTypeCode() != null) continue;
                        column.setSqlTypeCode(Integer.valueOf(column.getSqlTypeCode(mapping)));
                    }
                    this.exportTable(target, table, con, columns);
                }
                table = HibernateUniqueKeyTable.getMapping();
                this.exportTable(target, table, con, MappingUtils.getColumns(table));
            }
            finally {
                JDBCUtils.close((Connection)con);
            }
            target.end();
        }
        catch (SQLException e) {
            throw new JDBCTransferException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTable(TransferTarget target, Table table, Connection con, List<Column> columns) throws TransferException, SQLException {
        target.startTable(table);
        String sql = MappingUtils.sqlSelectAll(table);
        PreparedStatement statement = null;
        ResultSet rows = null;
        try {
            statement = con.prepareStatement(sql);
            rows = statement.executeQuery();
            while (rows.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (Column column : columns) {
                    row.put(column.getName(), rows.getObject(column.getName()));
                }
                target.row(row);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rows);
            JDBCUtils.close((PreparedStatement)statement);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rows);
        JDBCUtils.close((PreparedStatement)statement);
        target.endTable();
    }
}

