/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.test;

import com.zutubi.pulse.license.License;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.LicenseKeyFactory;
import com.zutubi.pulse.license.LicenseType;
import com.zutubi.pulse.util.StringUtils;
import java.util.Calendar;
import java.util.Date;

public class LicenseHelper {
    private static LicenseKeyFactory keyFactory;

    private static LicenseKeyFactory getKeyFactory() {
        if (keyFactory == null) {
            try {
                keyFactory = (LicenseKeyFactory)Class.forName("com.zutubi.pulse.license.LicenseEncoder").newInstance();
            }
            catch (Exception e) {
                keyFactory = new LicenseKeyFactory(){

                    public byte[] encode(License license) {
                        return new byte[0];
                    }
                };
            }
        }
        return keyFactory;
    }

    public static String newLicenseKey(LicenseType type, String holder) throws LicenseException {
        return LicenseHelper.newLicenseKey(type, holder, null);
    }

    public static String newExpiredLicenseKey(LicenseType type, String holder) throws LicenseException {
        Calendar cal = Calendar.getInstance();
        cal.add(1, -1);
        return LicenseHelper.newLicenseKey(type, holder, cal.getTime());
    }

    public static String newInvalidLicenseKey(LicenseType type, String holder) throws LicenseException {
        String validKey = LicenseHelper.newLicenseKey(type, holder, null);
        return validKey.substring(2, validKey.length() - 2);
    }

    public static String newLicenseKey(LicenseType type, String holder, Date expiry) throws LicenseException {
        return LicenseHelper.newLicenseKey(new License(type, holder, expiry));
    }

    public static String newLicenseKey(License license) throws LicenseException {
        byte[] licenseKey = LicenseHelper.getKeyFactory().encode(license);
        return StringUtils.wrapString((String)new String(licenseKey), (int)80, null);
    }
}

