/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.servlet;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;

public class FileServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(FileServlet.class);
    private FileSystemManager fsManager;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String path = request.getPathInfo();
            path = path.replace("\\", "/");
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = "pulse:///" + path;
            AbstractPulseFileObject pfo = (AbstractPulseFileObject)this.getFS().resolveFile(path);
            if (pfo.getType() == FileType.FILE) {
                this.doDownload(request, response, pfo);
            } else {
                this.doList(request, response, pfo);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void doList(HttpServletRequest request, HttpServletResponse response, AbstractPulseFileObject pfo) throws IOException {
        response.sendError(404, "Can not display requested resource '" + request.getPathInfo() + "', this resource it is not a file.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDownload(HttpServletRequest request, HttpServletResponse response, AbstractPulseFileObject pfo) throws IOException {
        String filename = pfo.getName().getBaseName();
        String contentType = pfo.getContent().getContentInfo().getContentType();
        if (TextUtils.stringSet((String)contentType)) {
            response.setContentType(contentType);
        } else {
            response.setContentType(URLConnection.guessContentTypeFromName(filename));
        }
        InputStream is = null;
        try {
            is = pfo.getContent().getInputStream();
            IOUtils.joinStreams((InputStream)is, (OutputStream)response.getOutputStream());
        }
        finally {
            IOUtils.close((Closeable)is);
        }
    }

    protected FileSystemManager getFS() throws FileSystemException {
        if (this.fsManager == null) {
            this.fsManager = (FileSystemManager)ComponentContext.getBean((String)"fileSystemManager");
        }
        return this.fsManager;
    }

    public void setFileSystemManager(FileSystemManager fsManager) {
        this.fsManager = fsManager;
    }
}

