/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.servlet;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;

public class DisplayServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(DisplayServlet.class);
    private FileSystemManager fsManager;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            AbstractPulseFileObject pfo;
            String path = request.getPathInfo();
            path = path.replace("\\", "/");
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.startsWith("pulse://")) {
                path = "pulse:///" + path;
            }
            try {
                pfo = (AbstractPulseFileObject)this.getFS().resolveFile(path);
            }
            catch (FileSystemException e) {
                path = path.replace('+', ' ');
                pfo = (AbstractPulseFileObject)this.getFS().resolveFile(path);
            }
            if (!(pfo instanceof AddressableFileObject)) {
                response.sendError(404, String.format("The path '%s' does not represent an addressable resource.", request.getPathInfo()));
                return;
            }
            AddressableFileObject afo = (AddressableFileObject)((Object)pfo);
            String url = afo.getUrlPath();
            if (afo.isLocal()) {
                if (!url.startsWith("/")) {
                    url = "/" + url;
                }
                url = request.getContextPath() + url;
            }
            response.sendRedirect(url);
        }
        catch (FileSystemException e) {
            LOG.error((Throwable)e);
            String message = e.getMessage();
            if (message.startsWith("Unknown message with code")) {
                message = e.getCode();
            }
            response.sendError(404, message);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected FileSystemManager getFS() throws FileSystemException {
        if (this.fsManager == null) {
            this.fsManager = (FileSystemManager)ComponentContext.getBean((String)"fileSystemManager");
        }
        return this.fsManager;
    }

    public void setFileSystemManager(FileSystemManager fsManager) {
        this.fsManager = fsManager;
    }
}

