/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.security.ldap;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.model.AcegiUser;
import com.zutubi.pulse.model.EmailContactPoint;
import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.security.ldap.LdapManager;
import com.zutubi.pulse.util.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.ldap.DefaultInitialDirContextFactory;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapUserSearch;
import org.acegisecurity.ldap.search.FilterBasedLdapUserSearch;
import org.acegisecurity.providers.ldap.authenticator.BindAuthenticator;
import org.acegisecurity.providers.ldap.populator.DefaultLdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcegiLdapManager
implements LdapManager {
    private static final Logger LOG = Logger.getLogger(AcegiLdapManager.class);
    private static final String EMAIL_CONTACT_NAME = "LDAP email";
    private boolean initialised = false;
    private MasterConfigurationManager configurationManager;
    private boolean enabled = false;
    private DefaultInitialDirContextFactory contextFactory;
    private BindAuthenticator authenticator;
    private DefaultLdapAuthoritiesPopulator populator = null;
    private boolean autoAdd = false;
    private String statusMessage = null;
    private String emailAttribute = null;
    private UserManager userManager;
    private Map<String, LdapUserDetails> detailsMap = new HashMap<String, LdapUserDetails>();

    @Override
    public void init() {
        this.initialised = false;
        this.statusMessage = null;
        MasterConfiguration appConfig = this.configurationManager.getAppConfig();
        this.enabled = appConfig.getLdapEnabled();
        this.autoAdd = appConfig.getLdapAutoAdd();
        this.emailAttribute = appConfig.getLdapEmailAttribute();
        if (this.enabled) {
            String hostUrl = appConfig.getLdapHostUrl();
            String baseDn = appConfig.getLdapBaseDn();
            String managerDn = appConfig.getLdapManagerDn();
            String managerPassword = appConfig.getLdapManagerPassword();
            boolean escapeSpaces = appConfig.getLdapEscapeSpaces();
            this.contextFactory = this.createContextFactory(hostUrl, baseDn, managerDn, managerPassword, escapeSpaces);
            this.authenticator = this.createAuthenticator(appConfig.getLdapUserFilter(), this.contextFactory);
            try {
                this.authenticator.afterPropertiesSet();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.statusMessage = e.getMessage();
                return;
            }
            if (TextUtils.stringSet((String)appConfig.getLdapGroupBaseDn())) {
                this.populator = this.createPopulator(appConfig.getLdapGroupBaseDn(), appConfig.getLdapGroupFilter(), appConfig.getLdapGroupRoleAttribute(), appConfig.getLdapGroupSearchSubtree(), escapeSpaces, this.contextFactory);
            }
        } else {
            this.contextFactory = null;
            this.authenticator = null;
            this.populator = null;
        }
        this.initialised = true;
    }

    private DefaultInitialDirContextFactory createContextFactory(String hostUrl, String baseDn, String managerDn, String managerPassword, boolean escapeSpaces) {
        if (escapeSpaces) {
            baseDn = this.escapeSpaces(baseDn);
            managerDn = this.escapeSpaces(managerDn);
        }
        if (!hostUrl.endsWith("/")) {
            hostUrl = hostUrl + '/';
        }
        DefaultInitialDirContextFactory result = new DefaultInitialDirContextFactory(hostUrl + baseDn);
        if (TextUtils.stringSet((String)managerDn)) {
            result.setManagerDn(managerDn);
            if (TextUtils.stringSet((String)managerPassword)) {
                result.setManagerPassword(managerPassword);
            }
        }
        return result;
    }

    private BindAuthenticator createAuthenticator(String userFilter, DefaultInitialDirContextFactory contextFactory) {
        FilterBasedLdapUserSearch search = new FilterBasedLdapUserSearch("", this.convertUserFilter(userFilter), (InitialDirContextFactory)contextFactory);
        search.setSearchSubtree(true);
        BindAuthenticator authenticator = new BindAuthenticator((InitialDirContextFactory)contextFactory);
        authenticator.setUserSearch((LdapUserSearch)search);
        return authenticator;
    }

    private DefaultLdapAuthoritiesPopulator createPopulator(String groupDn, String groupFilter, String groupRoleAttribute, boolean searchSubtree, boolean escapeSpaces, DefaultInitialDirContextFactory contextFactory) {
        if (escapeSpaces) {
            groupDn = this.escapeSpaces(groupDn);
        }
        DefaultLdapAuthoritiesPopulator populator = new DefaultLdapAuthoritiesPopulator((InitialDirContextFactory)contextFactory, groupDn);
        if (TextUtils.stringSet((String)groupFilter)) {
            populator.setGroupSearchFilter(this.convertGroupFilter(groupFilter));
        }
        if (TextUtils.stringSet((String)groupRoleAttribute)) {
            populator.setGroupRoleAttribute(groupRoleAttribute);
        }
        populator.setSearchSubtree(searchSubtree);
        populator.setRolePrefix("");
        populator.setConvertToUpperCase(false);
        return populator;
    }

    private String convertUserFilter(String userFilter) {
        return userFilter.replace("${login}", "{0}");
    }

    private String convertGroupFilter(String groupFilter) {
        return groupFilter.replace("${user.dn}", "{0}").replace("${login}", "{1}");
    }

    @Override
    public void connect() {
        this.statusMessage = null;
        try {
            this.contextFactory.newInitialDirContext();
        }
        catch (Exception e) {
            LOG.warning("Unable to connect to LDAP server: " + e.getMessage(), (Throwable)e);
            this.statusMessage = e.getMessage();
        }
    }

    @Override
    public User authenticate(String username, String password) {
        if (this.enabled && this.initialised) {
            try {
                LdapUserDetails details = this.authenticator.authenticate(username, password);
                String name = this.getStringAttribute(details, "cn", username);
                if (name == null) {
                    name = username;
                }
                User user = new User(username, name);
                if (TextUtils.stringSet((String)this.emailAttribute)) {
                    this.addContact(user, details);
                }
                this.detailsMap.put(username, details);
                return user;
            }
            catch (BadCredentialsException e) {
                LOG.info("LDAP login failure: user: " + username + " : " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.warning("Error contacting LDAP server: " + e.getMessage(), (Throwable)e);
                this.statusMessage = e.getMessage();
            }
        }
        return null;
    }

    @Override
    public void addLdapRoles(AcegiUser user) {
        LdapUserDetails details;
        if (this.populator != null && (details = this.detailsMap.get(user.getUsername())) != null) {
            try {
                List<Group> groups = this.getLdapGroups(details, this.populator);
                for (Group group : groups) {
                    LOG.debug("Adding user '" + details.getUsername() + "' to group '" + group.getName() + "' via LDAP");
                    for (com.zutubi.pulse.model.GrantedAuthority a : group.getAuthorities()) {
                        user.addTransientAuthority(a.getAuthority());
                    }
                }
            }
            catch (Exception e) {
                LOG.severe("Error retrieving group roles from LDAP server: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private List<Group> getLdapGroups(LdapUserDetails details, DefaultLdapAuthoritiesPopulator populator) {
        GrantedAuthority[] ldapAuthorities;
        LinkedList<Group> groups = new LinkedList<Group>();
        for (GrantedAuthority authority : ldapAuthorities = populator.getGrantedAuthorities(details)) {
            Group group = this.userManager.getGroup(authority.getAuthority());
            if (group == null) continue;
            groups.add(group);
        }
        return groups;
    }

    private void addContact(User user, LdapUserDetails details) {
        String email;
        if (user.getContactPoint(EMAIL_CONTACT_NAME) == null && (email = this.getStringAttribute(details, this.emailAttribute, user.getLogin())) != null) {
            EmailContactPoint point = new EmailContactPoint(email);
            point.setName(EMAIL_CONTACT_NAME);
            user.add(point);
        }
    }

    private String getStringAttribute(LdapUserDetails details, String attribute, String username) {
        Attribute att = details.getAttributes().get(attribute);
        if (att != null) {
            try {
                Object value = att.get();
                if (value instanceof String) {
                    return (String)value;
                }
            }
            catch (NamingException e) {
                LOG.debug("Unable to get attribute '" + attribute + "' for user '" + username + "': " + e.getMessage(), (Throwable)e);
            }
        } else {
            LOG.debug("User '" + username + "' has no common name (cn) attribute");
        }
        return null;
    }

    @Override
    public boolean canAutoAdd() {
        return this.enabled && this.initialised && this.autoAdd && LicenseHolder.hasAuthorization("canAddUser");
    }

    @Override
    public List<Group> testAuthenticate(String hostUrl, String baseDn, String managerDn, String managerPassword, String userFilter, String groupDn, String groupFilter, String groupRoleAttribute, boolean groupSearchSubtree, boolean escapeSpaces, String testLogin, String testPassword) {
        DefaultInitialDirContextFactory contextFactory = this.createContextFactory(hostUrl, baseDn, managerDn, managerPassword, escapeSpaces);
        contextFactory.newInitialDirContext();
        BindAuthenticator authenticator = this.createAuthenticator(userFilter, contextFactory);
        LdapUserDetails details = authenticator.authenticate(testLogin, testPassword);
        if (TextUtils.stringSet((String)groupDn)) {
            DefaultLdapAuthoritiesPopulator populator = this.createPopulator(groupDn, groupFilter, groupRoleAttribute, groupSearchSubtree, escapeSpaces, contextFactory);
            return this.getLdapGroups(details, populator);
        }
        return new ArrayList<Group>(0);
    }

    private String escapeSpaces(String dn) {
        return dn.replaceAll(" ", "\\\\20");
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

