/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.security;

import com.zutubi.pulse.model.AcegiUser;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.security.ldap.LdapManager;
import com.zutubi.pulse.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.DaoAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetails;

public class CustomAuthenticationProvider
extends DaoAuthenticationProvider {
    private static final Logger LOG = Logger.getLogger(CustomAuthenticationProvider.class);
    private UserManager userManager;
    private LdapManager ldapManager;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UsernamePasswordAuthenticationToken token;
        User user;
        if (this.ldapManager.canAutoAdd() && (user = this.userManager.getUser((token = (UsernamePasswordAuthenticationToken)authentication).getName())) == null) {
            LOG.debug("User '" + token.getName() + "' does not exist, asking LDAP manager");
            this.tryAutoAdd(token.getName(), (String)token.getCredentials());
        }
        return super.authenticate(authentication);
    }

    private void tryAutoAdd(String username, String password) {
        LOG.debug("Testing for user '" + username + "' via LDAP");
        User user = this.ldapManager.authenticate(username, password);
        if (user != null) {
            LOG.debug("User '" + username + "' found via LDAP, adding.");
            this.userManager.addUser(user, false, true);
        } else {
            LOG.debug("User '" + username + "' could not be authenticated via LDAP");
        }
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        AcegiUser user = (AcegiUser)userDetails;
        if (user.getUser().getLdapAuthentication()) {
            LOG.debug("Authenticating user '" + user.getUsername() + "' via LDAP");
            if (this.ldapManager.authenticate(authentication.getName(), authentication.getCredentials().toString()) == null) {
                LOG.debug("Authentication failed for user '" + user.getUsername() + "' via LDAP");
                throw new BadCredentialsException("Bad credentials");
            }
            this.ldapManager.addLdapRoles(user);
        } else {
            LOG.debug("Authenticating user '" + user.getUsername() + "' via stored password");
            super.additionalAuthenticationChecks(userDetails, authentication);
        }
    }

    public boolean supports(Class authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setLdapManager(LdapManager ldapManager) {
        this.ldapManager = ldapManager;
    }

    public void setUserManager(UserManager userManager) {
        this.setUserDetailsService(userManager);
        this.userManager = userManager;
    }
}

