/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm;

import com.zutubi.pulse.model.ScmManager;
import com.zutubi.pulse.scheduling.Task;
import com.zutubi.pulse.scheduling.TaskExecutionContext;
import com.zutubi.pulse.util.logging.Logger;

public class MonitorScms
implements Task {
    private static final Logger LOG = Logger.getLogger(MonitorScms.class);
    private ScmManager scmManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskExecutionContext context) {
        LOG.entering(MonitorScms.class.getName(), "execute");
        long start = System.currentTimeMillis();
        try {
            this.scmManager.pollActiveScms();
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            long time = (end - start) / 1000L;
            if (time > 100L) {
                LOG.warning("polling active Scms took %s seconds.", new Object[]{time});
            }
            throw throwable;
        }
        long end = System.currentTimeMillis();
        long time = (end - start) / 1000L;
        if (time > 100L) {
            LOG.warning("polling active Scms took %s seconds.", new Object[]{time});
        }
        LOG.exiting();
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }
}

