/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scheduling;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.scheduling.Trigger;
import java.io.Serializable;
import java.util.Date;

public class SimpleTrigger
extends Trigger {
    protected static final String TYPE = "simple";
    private static final String INTERVAL = "interval";
    private static final String REPEAT = "repeat";
    private static final String START_TIME = "start";
    public static final int REPEAT_INDEFINITELY = org.quartz.SimpleTrigger.REPEAT_INDEFINITELY;

    public SimpleTrigger() {
    }

    public SimpleTrigger copy(Project oldProject, Project newProject) {
        SimpleTrigger copy = new SimpleTrigger();
        this.copyCommon(copy, oldProject, newProject);
        return copy;
    }

    public SimpleTrigger(String name, String group, long interval) {
        this(name, group, new Date(), interval, REPEAT_INDEFINITELY);
    }

    public SimpleTrigger(String name, String group, Date time) {
        this(name, group, time, 0L, 0);
    }

    public SimpleTrigger(String name, String group, Date startTime, long interval, int repeatCount) {
        super(name, group);
        this.setInterval(interval);
        this.setRepeatCount(repeatCount);
        this.setStartTime(startTime);
    }

    public String getType() {
        return TYPE;
    }

    public Date getStartTime() {
        return (Date)this.getDataMap().get(START_TIME);
    }

    private void setStartTime(Date time) {
        this.getDataMap().put((Serializable)((Object)START_TIME), time);
    }

    private void setInterval(long interval) {
        this.getDataMap().put((Serializable)((Object)INTERVAL), Long.valueOf(interval));
    }

    public long getInterval() {
        return (Long)this.getDataMap().get(INTERVAL);
    }

    private void setRepeatCount(int repeat) {
        this.getDataMap().put((Serializable)((Object)REPEAT), Integer.valueOf(repeat));
    }

    public int getRepeatCount() {
        return (Integer)this.getDataMap().get(REPEAT);
    }
}

