/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scheduling;

import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.scheduling.EventTrigger;
import com.zutubi.pulse.scheduling.EventTriggerFilter;
import com.zutubi.pulse.scheduling.SchedulerStrategy;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.scheduling.TriggerHandler;
import com.zutubi.pulse.scheduling.TriggerState;
import com.zutubi.pulse.util.logging.Logger;
import java.util.HashMap;
import java.util.Map;

public class EventSchedulerStrategy
implements SchedulerStrategy {
    private static final Logger LOG = Logger.getLogger(EventSchedulerStrategy.class);
    private EventManager eventManager;
    private TriggerHandler triggerHandler;
    private Map<Long, EventListener> activeListenerMap = new HashMap<Long, EventListener>();
    private ObjectFactory objectFactory;

    public String canHandle() {
        return "event";
    }

    public void init(Trigger trigger) throws SchedulingException {
        if (trigger.isActive()) {
            this.register(trigger);
        }
    }

    public void schedule(Trigger trigger) throws SchedulingException {
        this.register(trigger);
    }

    public void unschedule(Trigger trigger) throws SchedulingException {
        this.unregister(trigger, TriggerState.NONE);
    }

    public void pause(Trigger trigger) throws SchedulingException {
        this.unregister(trigger, TriggerState.PAUSED);
    }

    public void resume(Trigger trigger) throws SchedulingException {
        this.register(trigger);
    }

    public void stop(boolean force) {
        for (EventListener listener : this.activeListenerMap.values()) {
            this.eventManager.unregister(listener);
        }
    }

    private void register(Trigger trigger) {
        EventTrigger eventTrigger = (EventTrigger)trigger;
        EventTriggerListener eventListener = new EventTriggerListener(eventTrigger, trigger);
        this.activeListenerMap.put(eventTrigger.getId(), eventListener);
        this.eventManager.register((EventListener)eventListener);
        trigger.setState(TriggerState.SCHEDULED);
    }

    private void unregister(Trigger trigger, TriggerState newState) {
        if (this.activeListenerMap.containsKey(trigger.getId())) {
            EventListener listener = this.activeListenerMap.remove(trigger.getId());
            this.eventManager.unregister(listener);
            trigger.setState(newState);
        }
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setTriggerHandler(TriggerHandler triggerHandler) {
        this.triggerHandler = triggerHandler;
    }

    public boolean dependsOnProject(Trigger trigger, long projectId) {
        Class<? extends EventTriggerFilter> filterClass = ((EventTrigger)trigger).getFilterClass();
        if (filterClass != null) {
            try {
                EventTriggerFilter filter = (EventTriggerFilter)this.objectFactory.buildBean(filterClass);
                return filter.dependsOnProject(trigger, projectId);
            }
            catch (Exception e) {
                LOG.severe("Unable to construct event filter of type '" + filterClass.getName() + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    private class EventTriggerListener
    implements EventListener {
        private final EventTrigger eventTrigger;
        private final Trigger trigger;

        public EventTriggerListener(EventTrigger eventTrigger, Trigger trigger) {
            this.eventTrigger = eventTrigger;
            this.trigger = trigger;
        }

        public Class[] getHandledEvents() {
            return this.eventTrigger.getTriggerEvents();
        }

        public void handleEvent(Event evt) {
            try {
                boolean accept = true;
                Class<? extends EventTriggerFilter> filterClass = this.eventTrigger.getFilterClass();
                if (filterClass != null) {
                    try {
                        EventTriggerFilter filter = (EventTriggerFilter)EventSchedulerStrategy.this.objectFactory.buildBean(filterClass);
                        accept = filter.accept(this.eventTrigger, evt);
                    }
                    catch (Exception e) {
                        LOG.severe("Unable to construct event filter of type '" + filterClass.getName() + "': " + e.getMessage(), (Throwable)e);
                    }
                }
                if (accept) {
                    EventSchedulerStrategy.this.triggerHandler.fire(this.trigger);
                }
            }
            catch (SchedulingException e) {
                LOG.severe((Throwable)((Object)e));
            }
        }
    }
}

