/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scheduling;

import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.model.persistence.TriggerDao;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.Task;
import com.zutubi.pulse.scheduling.TaskExecutionContext;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.scheduling.TriggerHandler;
import com.zutubi.pulse.util.logging.Logger;
import java.util.HashSet;
import java.util.Set;

public class DefaultTriggerHandler
implements TriggerHandler {
    private static final Logger LOG = Logger.getLogger(DefaultTriggerHandler.class);
    private ObjectFactory objectFactory;
    private TriggerDao triggerDao;
    private final Set<String> executingTriggers = new HashSet<String>();

    public void fire(Trigger trigger) throws SchedulingException {
        TaskExecutionContext context = new TaskExecutionContext();
        this.fire(trigger, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(Trigger trigger, TaskExecutionContext context) throws SchedulingException {
        if (trigger.isPersistent()) {
            trigger = (Trigger)((Object)this.triggerDao.findById(trigger.getId()));
        }
        String triggerKey = trigger.getName() + ":" + trigger.getGroup();
        Set<String> set = this.executingTriggers;
        synchronized (set) {
            if (this.executingTriggers.contains(triggerKey)) {
                LOG.info("Request to fire trigger '" + triggerKey + "' ignored since the trigger is already firing.");
                return;
            }
            LOG.info("executing trigger " + triggerKey);
            this.executingTriggers.add(triggerKey);
        }
        try {
            context.setTrigger(trigger);
            trigger.fire();
            try {
                Task task = (Task)this.objectFactory.buildBean(trigger.getTaskClass());
                task.execute(context);
            }
            catch (Exception e) {
                LOG.severe("Uncaught exception generated by execution of trigger " + triggerKey + ".", (Throwable)e);
                throw new SchedulingException(e);
            }
            catch (Throwable t) {
                LOG.severe("Uncaught throwable generated by execution of trigger " + triggerKey + ".", t);
                throw new SchedulingException(t);
            }
        }
        finally {
            set = this.executingTriggers;
            synchronized (set) {
                if (!this.executingTriggers.remove(triggerKey)) {
                    LOG.error("failed to remove trigger key from set.");
                } else {
                    LOG.info("finished trigger " + triggerKey);
                }
            }
        }
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setTriggerDao(TriggerDao triggerDao) {
        this.triggerDao = triggerDao;
    }
}

