/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scheduling;

import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventListener;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.system.SystemStartedEvent;
import com.zutubi.pulse.model.persistence.TriggerDao;
import com.zutubi.pulse.scheduling.Scheduler;
import com.zutubi.pulse.scheduling.SchedulerStrategy;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.scheduling.TriggerHandler;
import com.zutubi.pulse.util.logging.Logger;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScheduler
implements Scheduler,
EventListener {
    private static final Logger LOG = Logger.getLogger(DefaultScheduler.class);
    private Map<String, SchedulerStrategy> strategies = new TreeMap<String, SchedulerStrategy>();
    private TriggerHandler triggerHandler;
    private TriggerDao triggerDao;
    private boolean started = false;

    public void register(SchedulerStrategy strategy) {
        this.strategies.put(strategy.canHandle(), strategy);
        strategy.setTriggerHandler(this.triggerHandler);
    }

    public void setStrategies(List<SchedulerStrategy> schedulerStrategies) {
        this.strategies.clear();
        for (SchedulerStrategy strategy : schedulerStrategies) {
            this.register(strategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        try {
            for (SchedulerStrategy strategy : this.strategies.values()) {
                strategy.setTriggerHandler(this.triggerHandler);
            }
            for (Trigger trigger : this.triggerDao.findAll()) {
                SchedulerStrategy strategy = this.getStrategy(trigger);
                try {
                    strategy.init(trigger);
                }
                catch (SchedulingException e) {
                    LOG.severe("failed to initialise a trigger.", (Throwable)((Object)e));
                }
            }
        }
        finally {
            this.started = true;
        }
    }

    @Override
    public Trigger getTrigger(String name, String group) {
        return this.triggerDao.findByNameAndGroup(name, group);
    }

    @Override
    public Trigger getTrigger(long id) {
        return (Trigger)((Object)this.triggerDao.findById(id));
    }

    @Override
    public List<Trigger> getTriggers() {
        return this.triggerDao.findAll();
    }

    @Override
    public List<Trigger> getTriggers(long project) {
        return this.triggerDao.findByProject(project);
    }

    @Override
    public Trigger getTrigger(long project, String triggerName) {
        return this.triggerDao.findByProjectAndName(project, triggerName);
    }

    @Override
    public void schedule(Trigger trigger) throws SchedulingException {
        if (this.triggerDao.findByNameAndGroup(trigger.getName(), trigger.getGroup()) != null) {
            throw new SchedulingException("A trigger with name " + trigger.getName() + " and group " + trigger.getGroup() + " has already been registered.");
        }
        this.triggerDao.save(trigger);
        if (this.started) {
            SchedulerStrategy impl = this.getStrategy(trigger);
            impl.schedule(trigger);
        }
    }

    @Override
    public void trigger(Trigger trigger) throws SchedulingException {
        this.triggerHandler.fire(trigger);
    }

    @Override
    public void unschedule(Trigger trigger) throws SchedulingException {
        this.assertScheduled(trigger);
        SchedulerStrategy impl = this.getStrategy(trigger);
        impl.unschedule(trigger);
        this.triggerDao.delete(trigger);
    }

    @Override
    public void update(Trigger trigger) throws SchedulingException {
        this.assertScheduled(trigger);
        SchedulerStrategy impl = this.getStrategy(trigger);
        impl.unschedule(trigger);
        this.triggerDao.save(trigger);
        impl.schedule(trigger);
    }

    @Override
    public void pause(String group) throws SchedulingException {
        for (Trigger trigger : this.triggerDao.findByGroup(group)) {
            this.pause(trigger);
        }
    }

    @Override
    public void pause(Trigger trigger) throws SchedulingException {
        this.assertScheduled(trigger);
        if (!trigger.isActive()) {
            return;
        }
        SchedulerStrategy impl = this.getStrategy(trigger);
        impl.pause(trigger);
        this.triggerDao.save(trigger);
    }

    @Override
    public void resume(String group) throws SchedulingException {
        for (Trigger trigger : this.triggerDao.findByGroup(group)) {
            this.resume(trigger);
        }
    }

    @Override
    public void resume(Trigger trigger) throws SchedulingException {
        this.assertScheduled(trigger);
        if (!trigger.isPaused()) {
            return;
        }
        SchedulerStrategy impl = this.getStrategy(trigger);
        impl.resume(trigger);
        this.triggerDao.save(trigger);
    }

    @Override
    public void renameProjectTriggers(long project, String name) throws SchedulingException {
        List<Trigger> projectTriggers = this.getTriggers(project);
        for (Trigger trigger : projectTriggers) {
            SchedulerStrategy impl = this.getStrategy(trigger);
            impl.unschedule(trigger);
            trigger.setGroup(name);
            this.triggerDao.save(trigger);
            impl.schedule(trigger);
        }
    }

    @Override
    public void unscheduleAllTriggers(long project) throws SchedulingException {
        List triggers = this.triggerDao.findAll();
        for (Trigger trigger : triggers) {
            SchedulerStrategy impl = this.getStrategy(trigger);
            if (trigger.getProject() != project && !impl.dependsOnProject(trigger, project)) continue;
            impl.unschedule(trigger);
            this.triggerDao.delete(trigger);
        }
    }

    private SchedulerStrategy getStrategy(Trigger trigger) {
        return this.strategies.get(trigger.getType());
    }

    private void assertScheduled(Trigger trigger) throws SchedulingException {
        if (!trigger.isScheduled()) {
            throw new SchedulingException("The trigger must be scheduled first.");
        }
    }

    public void setTriggerDao(TriggerDao triggerDao) {
        this.triggerDao = triggerDao;
    }

    public void setTriggerHandler(TriggerHandler triggerHandler) {
        this.triggerHandler = triggerHandler;
    }

    public void setEventManager(EventManager eventManager) {
        eventManager.register((EventListener)this);
    }

    public void handleEvent(Event evt) {
        if (evt instanceof SystemStartedEvent) {
            this.start();
        }
    }

    public Class[] getHandledEvents() {
        return new Class[]{SystemStartedEvent.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean force) {
        if (!this.started) {
            return;
        }
        try {
            for (SchedulerStrategy strategy : this.strategies.values()) {
                strategy.stop(force);
            }
        }
        finally {
            this.started = false;
        }
    }
}

