/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.core.model.TestCaseIndex;
import com.zutubi.pulse.model.persistence.TestCaseIndexDao;
import com.zutubi.pulse.model.persistence.hibernate.HibernateEntityDao;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTestCaseIndexDao
extends HibernateEntityDao<TestCaseIndex>
implements TestCaseIndexDao {
    @Override
    public Class persistentClass() {
        return TestCaseIndex.class;
    }

    @Override
    public TestCaseIndex findByCase(final long stageNameId, final String name) {
        return (TestCaseIndex)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from TestCaseIndex model where model.stageNameId = :stageNameId and model.name = :name");
                queryObject.setParameter("stageNameId", (Object)stageNameId);
                queryObject.setParameter("name", (Object)name);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateTestCaseIndexDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        });
    }

    @Override
    public List<TestCaseIndex> findBySuite(final long stageNameId, final String suite) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from TestCaseIndex model where model.stageNameId = :stageNameId and model.name like :suite");
                queryObject.setParameter("stageNameId", (Object)stageNameId);
                queryObject.setParameter("suite", (Object)(suite + "%"));
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateTestCaseIndexDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public List<TestCaseIndex> findByStage(final long stageNameId) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from TestCaseIndex model where model.stageNameId = :stageNameId");
                queryObject.setParameter("stageNameId", (Object)stageNameId);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateTestCaseIndexDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public List<TestCaseIndex> findByProject(final long projectId, final int max) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from TestCaseIndex model where model.projectId = :projectId");
                queryObject.setParameter("projectId", (Object)projectId);
                queryObject.setMaxResults(max);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateTestCaseIndexDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }
}

