/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.Subscription;
import com.zutubi.pulse.model.persistence.SubscriptionDao;
import com.zutubi.pulse.model.persistence.hibernate.HibernateEntityDao;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSubscriptionDao
extends HibernateEntityDao<Subscription>
implements SubscriptionDao {
    @Override
    public Class persistentClass() {
        return Subscription.class;
    }

    @Override
    public List<Subscription> findByProject(final Project project) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("subscription.findByProject");
                queryObject.setParameter("project", (Object)project);
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateSubscriptionDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public List<Subscription> findByNoProject() {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from Subscription model where size(model.projects) = 0");
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateSubscriptionDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }
}

