/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.model.PersistentResource;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.persistence.ResourceDao;
import com.zutubi.pulse.model.persistence.hibernate.HibernateEntityDao;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateResourceDao
extends HibernateEntityDao<PersistentResource>
implements ResourceDao {
    @Override
    public Class persistentClass() {
        return PersistentResource.class;
    }

    @Override
    public List<PersistentResource> findAllBySlave(final Slave slave) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = HibernateResourceDao.this.createSlaveCriteria(session, slave);
                return criteria.list();
            }
        });
    }

    @Override
    public PersistentResource findBySlaveAndName(final Slave slave, final String name) {
        return (PersistentResource)((Object)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = HibernateResourceDao.this.createSlaveCriteria(session, slave);
                criteria.add((Criterion)Expression.eq((String)"name", (Object)name));
                return criteria.uniqueResult();
            }
        }));
    }

    private Criteria createSlaveCriteria(Session session, Slave slave) {
        Criteria criteria = session.createCriteria(PersistentResource.class);
        if (slave == null) {
            criteria.add(Expression.isNull((String)"slave"));
        } else {
            criteria.add((Criterion)Expression.eq((String)"slave", (Object)((Object)slave)));
        }
        return criteria;
    }
}

