/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectAclEntry;
import com.zutubi.pulse.model.persistence.ProjectAclDao;
import java.util.List;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateProjectAclDao
extends HibernateDaoSupport
implements ProjectAclDao {
    public Class persistentClass() {
        return ProjectAclEntry.class;
    }

    public BasicAclEntry[] getAcls(final AclObjectIdentity aclObjectIdentity) {
        List entries = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from ProjectAclEntry model where model.aclObjectIdentity = :project");
                queryObject.setEntity("project", (Object)aclObjectIdentity);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateProjectAclDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
        entries.add(new ProjectAclEntry("ROLE_ADMINISTRATOR", (Project)aclObjectIdentity, ProjectAclEntry.ADMINISTRATION));
        entries.add(new ProjectAclEntry("ROLE_USER", (Project)aclObjectIdentity, ProjectAclEntry.READ));
        return entries.toArray(new BasicAclEntry[entries.size()]);
    }

    @Override
    public List<ProjectAclEntry> findByRecipient(final String recipient) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from ProjectAclEntry model where model.recipient = :recipient");
                queryObject.setString("recipient", recipient);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateProjectAclDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }
}

