/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectGroup;
import com.zutubi.pulse.model.Subscription;
import com.zutubi.pulse.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends Entity {
    public static int REFRESH_DISABLED = 0;
    public static final String PROPERTY_DASHBOARD_BUILD_COUNT = "user.dashboardBuildCount";
    public static final String PROPERTY_DEFAULT_ACTION = "user.defaultAction";
    public static final String PROPERTY_LDAP_AUTHENTICATION = "user.ldapAuthentication";
    public static final String PROPERTY_SHOW_MY_CHANGES = "show.my.changes";
    public static final String PROPERTY_MY_CHANGES_COUNT = "my.changes.count";
    public static final String PROPERTY_SHOW_PROJECT_CHANGES = "show.project.changes";
    public static final String PROPERTY_PROJECT_CHANGES_COUNT = "project.changes.count";
    public static final String PROPERTY_REFRESH_INTERVAL = "user.refreshInterval";
    public static final String PROPERTY_TAIL_LINES = "tail.lines";
    public static final String PROPERTY_TAIL_REFRESH_INTERVAL = "tail.refresh.interval";
    public static final String PROPERTY_MY_BUILDS_COUNT = "my.builds.count";
    public static final String PROPERTY_SHOW_ALL_PROJECTS = "show.all.projects";
    public static final String PROPERTY_MY_BUILDS_COLUMNS = "my.builds.columns";
    public static final String PROPERTY_MY_PROJECTS_COLUMNS = "my.projects.columns";
    public static final String PROPERTY_ALL_PROJECTS_COLUMNS = "all.projects.columns";
    public static final String PROPERTY_PROJECT_SUMMARY_COLUMNS = "project.summary.columns";
    public static final String PROPERTY_PROJECT_RECENT_COLUMNS = "project.recent.columns";
    public static final String PROPERTY_PROJECT_HISTORY_COLUMNS = "project.history.columns";
    private String login;
    private String name;
    private boolean enabled;
    private String password;
    private List<ContactPoint> contactPoints;
    private Set<Project> shownProjects = new HashSet<Project>();
    private Set<ProjectGroup> shownGroups = new HashSet<ProjectGroup>();
    private List<String> authorities;
    private Set<Group> groups = new HashSet<Group>();
    private Map<String, String> properties;
    private List<String> aliases = new LinkedList<String>();
    private long nextBuildNumber = 1L;

    public User() {
    }

    public User(String login, String name) {
        this();
        this.login = login;
        this.name = name;
    }

    public User(String login, String name, String password, String ... authorities) {
        this(login, name);
        this.password = password;
        this.authorities = Arrays.asList(authorities);
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String encodedPassword) {
        this.password = encodedPassword;
    }

    public void add(ContactPoint point) {
        this.getContactPoints().add(point);
        point.setUser(this);
    }

    public boolean remove(ContactPoint point) {
        if (this.contactPoints.remove((Object)point)) {
            point.setUser(null);
            return true;
        }
        return false;
    }

    private void setContactPoints(List<ContactPoint> l) {
        this.contactPoints = l;
    }

    public List<ContactPoint> getContactPoints() {
        if (this.contactPoints == null) {
            this.contactPoints = new LinkedList<ContactPoint>();
        }
        return this.contactPoints;
    }

    public ContactPoint getContactPoint(String name) {
        for (ContactPoint cp : this.getContactPoints()) {
            if (cp.getName().compareTo(name) != 0) continue;
            return cp;
        }
        return null;
    }

    public ContactPoint getContactPoint(long contactPointId) {
        for (ContactPoint cp : this.contactPoints) {
            if (cp.getId() != contactPointId) continue;
            return cp;
        }
        return null;
    }

    public List<Subscription> getSubscriptions() {
        LinkedList<Subscription> subscriptions = new LinkedList<Subscription>();
        for (ContactPoint cp : this.contactPoints) {
            subscriptions.addAll(cp.getSubscriptions());
        }
        return subscriptions;
    }

    public Subscription getSubscription(long id) {
        for (Subscription s : this.getSubscriptions()) {
            if (s.getId() != id) continue;
            return s;
        }
        return null;
    }

    List<String> getGrantedAuthorities() {
        if (this.authorities == null) {
            this.authorities = new ArrayList<String>();
        }
        return this.authorities;
    }

    private void setGrantedAuthorities(List<String> authorities) {
        this.authorities = authorities;
    }

    public void add(String authority) {
        if (!this.hasAuthority(authority)) {
            this.getGrantedAuthorities().add(authority);
        }
    }

    public void remove(String authority) {
        this.getGrantedAuthorities().remove(authority);
    }

    public boolean hasAuthority(String authority) {
        return this.getGrantedAuthorities().contains(authority);
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    private void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public boolean removeAlias(String alias) {
        return this.aliases.remove(alias);
    }

    public void removeAlias(int index) {
        if (index <= this.aliases.size()) {
            this.aliases.remove(index);
        }
    }

    public boolean hasAlias(String alias) {
        return this.aliases.contains(alias);
    }

    public Set<Project> getShownProjects() {
        return this.shownProjects;
    }

    public void setShownProjects(Set<Project> shownProjects) {
        this.shownProjects = shownProjects;
    }

    public Set<ProjectGroup> getShownGroups() {
        return this.shownGroups;
    }

    public void setShownGroups(Set<ProjectGroup> shownGroups) {
        this.shownGroups = shownGroups;
    }

    public void setProperties(Map<String, String> props) {
        this.properties = props;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public String getProperty(String key) {
        return this.getProperties().get(key);
    }

    public boolean hasProperty(String key) {
        return this.getProperties().containsKey(key);
    }

    public String getDefaultAction() {
        if (this.hasProperty(PROPERTY_DEFAULT_ACTION)) {
            return this.getProperty(PROPERTY_DEFAULT_ACTION);
        }
        return "dashboard";
    }

    public void setDefaultAction(String defaultAction) {
        this.setProperty(PROPERTY_DEFAULT_ACTION, defaultAction);
    }

    public int getRefreshInterval() {
        if (this.hasProperty(PROPERTY_REFRESH_INTERVAL)) {
            return Integer.valueOf(this.getProperty(PROPERTY_REFRESH_INTERVAL));
        }
        return 60;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.setProperty(PROPERTY_REFRESH_INTERVAL, Integer.toString(refreshInterval));
    }

    public int getTailRefreshInterval() {
        return this.getIntProperty(PROPERTY_TAIL_REFRESH_INTERVAL, 60);
    }

    public void setTailRefreshInterval(int interval) {
        this.setIntProperty(PROPERTY_TAIL_REFRESH_INTERVAL, interval);
    }

    public int getTailLines() {
        return this.getIntProperty(PROPERTY_TAIL_LINES, 30);
    }

    public void setTailLines(int lines) {
        this.setIntProperty(PROPERTY_TAIL_LINES, lines);
    }

    public int getDashboardBuildCount() {
        if (this.hasProperty(PROPERTY_DASHBOARD_BUILD_COUNT)) {
            return Integer.valueOf(this.getProperty(PROPERTY_DASHBOARD_BUILD_COUNT));
        }
        return 2;
    }

    public void setDashboardBuildCount(int buildCount) {
        this.setProperty(PROPERTY_DASHBOARD_BUILD_COUNT, Integer.toString(buildCount));
    }

    public boolean getLdapAuthentication() {
        return this.getBooleanProperty(PROPERTY_LDAP_AUTHENTICATION, false);
    }

    public void setLdapAuthentication(boolean useLdap) {
        this.setBooleanProperty(PROPERTY_LDAP_AUTHENTICATION, useLdap);
    }

    public boolean getShowAllProjects() {
        return this.getBooleanProperty(PROPERTY_SHOW_ALL_PROJECTS, true);
    }

    public void setShowAllProjects(boolean show) {
        this.setBooleanProperty(PROPERTY_SHOW_ALL_PROJECTS, show);
    }

    public boolean getShowMyChanges() {
        return this.getBooleanProperty(PROPERTY_SHOW_MY_CHANGES, true);
    }

    public void setShowMyChanges(boolean show) {
        this.setBooleanProperty(PROPERTY_SHOW_MY_CHANGES, show);
    }

    public int getMyChangesCount() {
        return this.getIntProperty(PROPERTY_MY_CHANGES_COUNT, 10);
    }

    public void setMyChangesCount(int count) {
        this.setIntProperty(PROPERTY_MY_CHANGES_COUNT, count);
    }

    public boolean getShowProjectChanges() {
        return this.getBooleanProperty(PROPERTY_SHOW_PROJECT_CHANGES, false);
    }

    public void setShowProjectChanges(boolean show) {
        this.setBooleanProperty(PROPERTY_SHOW_PROJECT_CHANGES, show);
    }

    public int getProjectChangesCount() {
        return this.getIntProperty(PROPERTY_PROJECT_CHANGES_COUNT, 10);
    }

    public void setProjectChangesCount(int count) {
        this.setIntProperty(PROPERTY_PROJECT_CHANGES_COUNT, count);
    }

    public int getMyBuildsCount() {
        return this.getIntProperty(PROPERTY_MY_BUILDS_COUNT, 5);
    }

    public void setMyBuildsCount(int count) {
        this.setIntProperty(PROPERTY_MY_BUILDS_COUNT, count);
    }

    public String getMyBuildsColumns() {
        return this.getStringProperty(PROPERTY_MY_BUILDS_COLUMNS, StringUtils.join((String)",", (String[])new String[]{"id", "project", "spec", "status", "tests", "when", "elapsed", "actions"}));
    }

    public void setMyBuildsColumns(String columns) {
        this.setProperty(PROPERTY_MY_BUILDS_COLUMNS, columns);
    }

    public String getMyProjectsColumns() {
        return this.getStringProperty(PROPERTY_MY_PROJECTS_COLUMNS, User.getDefaultProjectColumns());
    }

    public void setMyProjectsColumns(String columns) {
        this.setProperty(PROPERTY_MY_PROJECTS_COLUMNS, columns);
    }

    public String getAllProjectsColumns() {
        return this.getStringProperty(PROPERTY_ALL_PROJECTS_COLUMNS, User.getDefaultAllProjectsColumns());
    }

    public void setAllProjectsColumns(String columns) {
        this.setProperty(PROPERTY_ALL_PROJECTS_COLUMNS, columns);
    }

    public String getProjectSummaryColumns() {
        return this.getStringProperty(PROPERTY_PROJECT_SUMMARY_COLUMNS, User.getDefaultProjectColumns());
    }

    public void setProjectSummaryColumns(String columns) {
        this.setProperty(PROPERTY_PROJECT_SUMMARY_COLUMNS, columns);
    }

    public String getProjectRecentColumns() {
        return this.getStringProperty(PROPERTY_PROJECT_RECENT_COLUMNS, User.getDefaultProjectColumns());
    }

    public void setProjectRecentColumns(String columns) {
        this.setProperty(PROPERTY_PROJECT_RECENT_COLUMNS, columns);
    }

    public String getProjectHistoryColumns() {
        return this.getStringProperty(PROPERTY_PROJECT_HISTORY_COLUMNS, User.getDefaultProjectColumns());
    }

    public void setProjectHistoryColumns(String columns) {
        this.setProperty(PROPERTY_PROJECT_HISTORY_COLUMNS, columns);
    }

    public static String getDefaultProjectColumns() {
        return StringUtils.join((String)",", (String[])new String[]{"id", "spec", "status", "reason", "tests", "when", "elapsed", "actions"});
    }

    public static String getDefaultAllProjectsColumns() {
        return StringUtils.join((String)",", (String[])new String[]{"id", "spec", "status", "reason", "tests", "when", "elapsed", "actions"});
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof User)) {
            return false;
        }
        return this.login.equals(((User)((Object)other)).login);
    }

    public int hashCode() {
        return this.login.hashCode();
    }

    private boolean getBooleanProperty(String property, boolean defaultValue) {
        if (this.hasProperty(property)) {
            return Boolean.valueOf(this.getProperty(property));
        }
        return defaultValue;
    }

    private void setBooleanProperty(String property, boolean value) {
        this.setProperty(property, Boolean.toString(value));
    }

    private int getIntProperty(String property, int defaultValue) {
        if (this.hasProperty(property)) {
            return Integer.parseInt(this.getProperty(property));
        }
        return defaultValue;
    }

    private void setIntProperty(String property, int value) {
        this.setProperty(property, Integer.toString(value));
    }

    private String getStringProperty(String property, String defaultValue) {
        if (this.hasProperty(property)) {
            return this.getProperty(property);
        }
        return defaultValue;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    private void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    void addGroup(Group group) {
        this.groups.add(group);
    }

    void removeGroup(Group group) {
        this.groups.remove((Object)group);
    }

    public long getNextBuildNumber() {
        return this.nextBuildNumber;
    }

    public void setNextBuildNumber(long nextBuildNumber) {
        this.nextBuildNumber = nextBuildNumber;
    }
}

